module LanternLantern

using ..Ahorn, Maple

@mapdef Entity "lantern/lantern" Lantern(x::Integer, y::Integer, particleColor::String="e3bf70", deathEffectColor::String="e3bf70", onlyFits::Integer=-1, oneUse::Bool=false, ignoreBarriers::Bool=false, forceVerticalCollision::Bool=false)

const placements = Ahorn.PlacementDict(
    "Lantern (Lantern)" => Ahorn.EntityPlacement(
        Lantern,
        "point",
        Dict{String, Any}(
            "dischargeRate" => 0,
        )
    )
)

sprite = "lantern/lantern/lantern0"

function Ahorn.selection(entity::Lantern)
    x, y = Ahorn.position(entity)

    return Ahorn.getSpriteRectangle(sprite, x, y - 8)
end

Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::Lantern, room::Maple.Room) = Ahorn.drawSprite(ctx, sprite, 0, -8)

end
