module LanternLanternGate

using ..Ahorn, Maple

@mapdef Entity "Lantern/lantern_gate" LanternGate(x::Integer, y::Integer, vertical::Bool=true, closes::Bool=false, switchId::Integer=-1)

const placements = Ahorn.PlacementDict(
    "Lantern Gate (Vertical) (Lantern)" => Ahorn.EntityPlacement(
        LanternGate,
        "point",
        Dict{String, Any}(
            "vertical" => true,
        )
    ),
    "Lantern Gate (Horizontal) (Lantern)" => Ahorn.EntityPlacement(
        LanternGate,
        "point",
        Dict{String, Any}(
            "vertical" => false,
        )
    ),
    "Closing Lantern Gate (Vertical) (Lantern)" => Ahorn.EntityPlacement(
        LanternGate,
        "point",
        Dict{String, Any}(
            "vertical" => true,
            "closes" => true,
        )
    ),
    "Closing Lantern Gate (Horizontal) (Lantern)" => Ahorn.EntityPlacement(
        LanternGate,
        "point",
        Dict{String, Any}(
            "vertical" => false,
            "closes" => true,
        )
    ),
)

function Ahorn.selection(entity::LanternGate)
    x, y = Ahorn.position(entity)
    height = Int(get(entity.data, "height", 48))

    if get(entity.data, "vertical", true)
        return Ahorn.Rectangle(x, y, 15, height)
    else
        return Ahorn.Rectangle(x, y, height, 15)
    end
end

function Ahorn.render(ctx::Ahorn.Cairo.CairoContext, entity::LanternGate, room::Maple.Room)
    if get(entity.data, "closes", false)
        sprite = "lantern/lantern_gate/door15"
    else
        sprite = "lantern/lantern_gate/door1"
    end

    if get(entity.data, "vertical", true)
        Ahorn.drawSprite(ctx, sprite, 7, 24)
    else
        Ahorn.drawSprite(ctx, sprite, 12, 44, rot=-pi / 2)
    end
end

end
