local drawableSprite = require("structs.drawable_sprite")
local utils = require("utils")

local lantern_gate = {}

lantern_gate.name = "lantern/lantern_gate"
lantern_gate.depth = -9000

lantern_gate.placements = {
    {
        name = "vertical",
        data = {
            switchId = -1,
            vertical = true,
            closes = false
        }
    },
    {
        name = "vertical_closing",
        data = {
            switchId = -1,
            vertical = true,
            closes = true
        }
    },
    {
        name = "horizontal",
        data = {
            switchId = -1,
            vertical = false,
            closes = false
        }
    },
    {
        name = "horizontal_closing",
        data = {
            switchId = -1,
            vertical = false,
            closes = true
        }
    },
}

lantern_gate.fieldInformation = {
    switchId = {
        fieldType = "integer"
    }
}

lantern_gate.fieldOrder = {"x", "y", "switchId", "vertical", "closes"}

lantern_gate.canResize = {false, false} -- prevent resizing gates placed with old Ahorn plugin

function lantern_gate.sprite(room, entity)
    local texture = (entity.closes ? "lantern/lantern_gate/door15" : "lantern/lantern_gate/door1")
    local sprite = drawableSprite.fromTexture(texture, entity)
    sprite:setJustification(0.5, 0)

    if entity.vertical then
        sprite:addPosition(7, 0)
    else
        sprite:addPosition(0, 8)
        sprite.rotation = -math.pi / 2
    end

    return sprite
end

function lantern_gate.selection(room, entity)
    if entity.vertical then
        return utils.rectangle(entity.x, entity.y, 15, 48)
    else
        return utils.rectangle(entity.x, entity.y, 48, 15)
    end
end

return lantern_gate
