local engine = require("#monocle.engine")
local monocle = require("#monocle")
local celeste = require("#celeste")

local coroutineEntity = monocle.Entity()

function onBegin()
    if not getFlag("badelineWatched") then
        local level = getLevel()
        local luanet = _G.luanet
        local return_pos = getLevel().Camera.Position
        level:add(coroutineEntity)
        vector = player.Position + vector2(0, 0)
        player.ForceCameraUpdate = false
        disableMovement()

        player.Sprite:Play("walk")
        coroutineEntity:add(monocle.Coroutine(player:DummyWalkTo(player.Position.X + 80, false, 1)))        -- change the "40" here to however far you need madeline to walk
        coroutineEntity:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(16000, -1870), 2.5)))    -- the 7680 and 2800 are the world coordinates, will need to be adjusted
        wait(1)        -- wait for madeline to land on the ground before spawning badeline, raise this if you see badeline spawning above the ground

        badeline = celeste.BadelineDummy(vector2(16240,-1792))        -- adjust these to spawn badeline where you want, i think the -40 should be good but maybe not the 200
        badeline.Floatness = 0
        level:Add(badeline)
        badeline.Sprite:Play("idle")

        wait(1.3)
		say("maddy_entranceA") 
        badeline.Sprite.Scale = vector2(1, 1)
        wait(.2)
        coroutine.yield(badeline:WalkTo(badeline.X + 100))
        badeline:RemoveSelf()
		coroutineEntity:add(monocle.Coroutine(player:DummyWalkTo(player.Position.X + 30, false, 1)))
		say("maddy_entranceB") 
        coroutineEntity:add(monocle.Coroutine(celeste.CutsceneEntity.CameraTo(vector2(15965, -1864), 2.5)))    -- camera pans back to madeline, play with these world coordinates until you get something that works
        wait(1)
		say("maddy_entranceC") 
        player.ForceCameraUpdate = true
        player.DummyAutoAnimate = true
        enableMovement()
        setFlag("badelineWatched", true)        -- remove this line if you wanna test the cutscene repeatedly
    end
end

function onEnd(room, wasSkipped)
    getLevel():remove(coroutineEntity)
    if wasSkipped then
        player.ForceCameraUpdate = true
        player.DummyAutoAnimate = true
        player.Position = vector2(16081, -1755)            -- where madeline should go after skipping cutscene, these are also world coordinates so play around with them
        if badeline then
            badeline:RemoveSelf()
        end
        enableMovement()
        setFlag("badelineWatched", true)
    end
end