local BounceDecal = {}

BounceDecal.name = "probananahelper/BounceDecal"
BounceDecal.depth = 0
BounceDecal.placements = {
    {
        name = "BounceDecal",
        data = {
            angle = 0,
            rotationCenterX = 0,
            rotationCenterY = 0,
            sizeX = 19,
            sizeY = 41,
            offsetX = 5,
            offsetY = 27,
            strength = 400,
            idleSprite = "probananahelper/cactusIdle",
            hitSprite = "probananahelper/cactusHit",
            frameDelay = 0.1,
            sound = "event:/probanana/Cactus",
            destroy = false,
            knockback = 0,
            knockbackSpeed = 0,
            flag = ""
        }
    },
    {
        name = "BreakDecal",
        data = {
            angle = 0,
            rotationCenterX = 0,
            rotationCenterY = 0,
            sizeX = 21,
            sizeY = 18,
            offsetX = 62,
            offsetY = 27,
            strength = 300,
            idleSprite = "probananahelper/crackedBoxA",
            hitSprite = "probananahelper/boxExplode",
            frameDelay = 0.066,
            sound = "event:/probanana/BoxExplode",
            destroy = true,
            knockback = 0,
            knockbackSpeed = 0,
            flag = ""
        }
    }
}

function BounceDecal.rotation(room, entity)
    return math.rad(entity.angle)
end

function BounceDecal.texture(room, entity)
    return "decals/" .. entity.idleSprite .. "00"
end

function BounceDecal.justification(room, entity)
	return 0,0
end

return BounceDecal