local utils = require("utils")

local basketball = {
    name = "Frigohelper/Basketball",
    depth = 43,
    justification = {0.5,1},
    placements = {
        {
            name = "basketball",
            data = {
                noGravity = false,
                yeetingPower = 0,
            }
        },
        {
            name = "chargedbasketball",
            data = {
                noGravity = false,
                yeetingPower = 0.5,
            }
        },
        {
            name = "binglebasketball",
            data = {
                noGravity = false,
                yeetingPower = 1,
            }
        },
        {
            name = "spacebasketball",
            data = {
                noGravity = true,
                yeetingPower = 0.5,
            }
        },
    },
    fieldOrder = {
        "x", "y",
        "yeetingPower",
        "customColor",
        "noGravity",
        "useCustomColor",
    },
    fieldInformation = {
        useCustomColor = {
            default = false,
        },
        customColor = {
            fieldType = "color",
            default = "000000",
        },
    },
    texture = function (room, entity)
        return "objects/FrigoHelper/basketball/"..(entity.noGravity and "weespace00" or "wee00")
    end,
    color = function(room, entity)
        ---[[
        if entity.useCustomColor and entity.customColor then
            return utils.getColor(entity.customColor)
        end
        --]]

        local x = entity.yeetingPower
        local l0 = (x-0.5)*(x-1)/0.5
        local l1 = -x*(x-1)/0.25
        local l2 = x*(x-0.5)/0.5
        return {
            math.log(math.exp(255/255)*l0 + math.exp(71/255)*l1 + math.exp(255/255)*l2),
            math.log(math.exp(127/255)*l0 + math.exp(74/255)*l1 + math.exp(60/255)*l2),
            math.log(math.exp(39/255)*l0 + math.exp(255/255)*l1 + math.exp(255/255)*l2),

            --2.88627*x^2 - 2.88627*x + 1,
            --0.498039 - 0.568627*x + 0.305882*x^2,
            --0.152941 + 2.54118*x - 1.69412*x^2,
        }
    end,
}

return basketball