local rotations = {
    Forward = "hoopforward",
    Rotated = "hooprotated",
    Sideways = "hoopsideways",
}

local hoop = {
    name = "Frigohelper/Hoop",
    justification = {0.5,0.5},
    fieldInformation = {
        rotation = {
            options = rotations,
            editable = false,
        }
    },
    placements = {
        {
            name = "hoopforward",
            data = {
                rotation = "hoopforward",
                flipX = false,
            },
        },
        {
            name = "hooprotatedright",
            data = {
                rotation = "hooprotated",
                flipX = false,
            },
        },
        {
            name = "hooprotatedleft",
            data = {
                rotation = "hooprotated",
                flipX = true,
            },
        },
        {
            name = "hoopsidewaysright",
            data = {
                rotation = "hoopsideways",
                flipX = false,
            },
        },
        {
            name = "hoopsidewaysleft",
            data = {
                rotation = "hoopsideways",
                flipX = true,
            },
        },
    },
    texture = function(room, entity)
        return "objects/FrigoHelper/hoop/"..entity.rotation.."full00"
    end,
    depth = function(room, entity)
        return entity.rotation == "hoopsidewaysfull00" and -10501 or 2006
    end,
    scale = function(room, entity)
        return { entity.flipX and -1 or 1, 1 }
    end
}

return hoop