-- ignore this, just getting VScode to shut up
---@diagnostic disable: undefined-global
---@diagnostic disable: lowercase-global

-- The IDs of the choicers we've gone through are stored here. Choosing a back option moves back one step, and if the stack is empty, it'll end the choicer.
choicer_stack = {}

-- Every choicer used in this cutscene. They MUST all be in this table, or else there may be issues with moving between them.
choicers = {
    choicer_intro = {
        {
            dialog = "SenselessSpirit_SenselessZescent_CHM_CreditsLink",
            exit = true
        },

        {
            dialog = "SenselessSpirit_SenselessZescent_CHM_CreditsRead",
            page = "choicer_page1",
            say = false
        },

        {
            dialog = "SenselessSpirit_SenselessZescent_CHM_CreditsNevermind",
            exit = true
        }
    },

    choicer_page1 = {
        {
            dialog = "SenselessSpirit_SenselessZescent_CHM_Credits_SenselessSpirit"
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CHM_Credits_Xiloscient"
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CHM_Credits_Spooooky"
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CHM_Credits_Siret"
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CHM_Credits_Raemirs"
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CHM_Credits_JaviGutierrez"
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CHM_Credits_Undefineddd"
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CHM_Credits_Agent7"
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CHM_Credits_Cherry"
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CHM_Credits_PoorlyDrawnCactus"
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CHM_Credits_Yakaki"
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CHM_Credits_Avoset"
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CHM_Credits_GuiGui"
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CHM_Credits_ar_chive"
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CHM_Credits_BGD"
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CHM_Credits_Orion"
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CHM_Credits_Kashi"
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CHM_Credits_grog"
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_MuseumChangelogsEnd",
            say = false,
            exit = true
        }

    }
}


function onTalk()
    disableMovement()
    say("SenselessSpirit_SenselessZescent_CHM_CreditsIntro")

    -- First argument is the name of your choicer table.
    -- Second is if this choicer should be added to the choicer tree. Defaults to true.
    choiceDialog(convertChoicer("choicer_intro", false))
end

function onEnd(room, wasSkipped)
    enableMovement()
end

function convertChoicer(choicer, add_stack) -- Converts a choicer skeleton into a table usable by the choiceDialog helper function.
    add_stack = add_stack ~= false
    local newchoicer = {}
    for i, choice in ipairs(choicers[choicer]) do 
        local prev_stack = choice.prev_stack ~= false
        newchoicer[i] = {
            choice.dialog,
            repeatable = true,
            requires = choice.condition,
            onChosen = function()
                if choice.say ~= false then say(choice.dialog .. "_say") end
                if choice.func then choice.func() end
                if choice.page then
                    if choice.say == false then wait(0.2) end
                    choiceDialog(convertChoicer(choice.page, prev_stack))
                end
                if choice.exit then closeChoiceDialog() end
                if choice.back and not choice.exit then
                    if choice.say == false then wait(0.2) end
                    table.remove(choicer_stack, #choicer_stack) -- Remove the end of the stack
                    if #choicer_stack <= 0 then
                        closeChoiceDialog()
                    else
                        choiceDialog(convertChoicer(choicer_stack[#choicer_stack], false)) -- Create whatever table is at the end of the stack
                    end
                end
            end
        }
    end
    if add_stack then table.insert(choicer_stack, choicer) end
    return newchoicer
end
