-- The format for dialogue keys using this system is as follows:
-- SenselessSpirit_SenselessZescent_CH1_LIBRARY_SHELFNUM_BOOK_TITLE_PAGENUM
-- The book title part will have additional formatting applied to it:
-- It's made to be all caps, spaces are replaced with underscores, and, hopefully, non-alphanumeric characters are removed.
-- Example: "Book of Lore: Volume 1" will become "BOOK_OF_LORE_VOLUME_1".
-- I dunno how to use the formatting functions all that well, so try and keep special characters to a minimum.
local shelves = {
    -- Shelves are pulled from this big table.
    -- The shelves are indexed with a number, and are listed numerically.
    -- Each shelf has its own table.
    [1] = {
        -- Each shelf has another table in it, labeled books.
        books = {
            -- Books are indexed with a number, like shelves. Each book has a "title" field, and a "pages" field.
            [1] = {
                title = "Book of Lore: Volume 1", -- When displayed as a choicer option, the title is used as part of its dialogue key. 
                pages = 3 -- Pages is a number determining how many options you'll have once you select the book.
            },
            [2] = {
                title = "Book of Lore: Volume 2",
                pages = 4
            },
            [3] = {
                title = "Book of Lore: Volume 3",
                pages = 5
            }
        }
    },
    [2] = {
        books = {
            [1] = {
                title = "Book of Lore: Volume 4",
                pages = 6
            },
            [2] = {
                title = "Book of Lore: Volume 5",
                pages = 4
            },
            [3] = {
                title = "Book of Lore: Volume 6",
                pages = 2
            }
        }
    },
    [3] = {
        books = {
            [1] = {
                title = "Book of Lore: Volume 7",
                pages = 5
            },
            [2] = {
                title = "Book of Lore: Volume 8",
                pages = 4
            },
        }
    }
}



function onTalk()
    local result = {}
    local menuPosition = {}
    setFlag("CinematicFadeFlag",true)
    disableMovement()
    say("SenselessSpirit_SenselessZescent_AtticLibraryView")

    choiceDialog({
        {
            -- I have time.
            "SenselessSpirit_SenselessZescent_AtticLibraryGeneral",
            repeatable = true,
            onEnd = function ()
                pick_shelf()
            end
        },
        {
            -- Never mind.
            "SenselessSpirit_SenselessZescent_AtticLibraryCease",
            onEnd = function ()
                closeChoiceDialog()
            end
        },
    })
setFlag("CinematicFadeFlag",false)
end


function pick_shelf()
    local choices = {}
    -- Dynamic choicer. An option is created for every entry in the shelves table at the top of this file.
    for i, shelf in ipairs(shelves) do
        table.insert(choices,
        { "SenselessSpirit_SenselessZescent_CH1_LIBRARY_" .. i,
            repeatable = true,
            onChosen = function ()
                wait(0.3)
                pick_book(i)
            end
        })
    end
    table.insert(choices, {
        -- Closes the choicer and ends the cutscene.
        -- (Stop reading)
        "SenselessSpirit_SenselessZescent_AtticLibraryBack",
        onEnd = function ()
            closeChoiceDialog()
        end
    })
    choiceDialog(choices)
end

function pick_book(num)
    local choices = {}
    -- Dynamic choicer. An option is created for every book in a given shelf.
    for i, book in ipairs(shelves[num].books) do
        table.insert(choices,
        { "SenselessSpirit_SenselessZescent_CH1_LIBRARY_" .. num .. "_" .. book.title:upper():gsub(" - ", "_"):gsub(":", ""),
        repeatable = true,
        onChosen = function ()
            wait(0.3)
            pick_page(num, i)
        end
    })
    end
    table.insert(choices, {
        "SenselessSpirit_SenselessZescent_AtticLibraryBack_Book",
        onChosen = function ()
            wait(0.3)
            pick_shelf()
        end
    })
    choiceDialog(choices)
end

function pick_page(shelf, book)
    local choices = {}
    -- Dynamic choicer. An option is created for every page in a given book.
    for i=1, shelves[shelf].books[book].pages do
        table.insert(choices,
        { "SenselessSpirit_SenselessZescent_CH1_LIBRARY_" .. shelf .. "_" .. shelves[shelf].books[book].title:upper():gsub(" - ", "_"):gsub(":", "") .. "_" .. i,
        repeatable = true,
    })
    end
    table.insert(choices, {
        "SenselessSpirit_SenselessZescent_AtticLibraryBack_Page",
        onChosen = function ()
            wait(0.3)
            pick_book(shelf)
        end
    })
    choiceDialog(choices)
end

function onEnd(room, wasSkipped)
    setFlag("CinematicFadeFlag",false)
    enableMovement()
end
