using Celeste.Mod.Entities;
using Microsoft.Xna.Framework;

namespace Celeste.Mod.exampleMod.Entities;

[CustomEntity("borealisHelper/SampleTrigger")]
public class SampleTrigger : Trigger {

    private Vector2 stored;

    public SampleTrigger(EntityData data, Vector2 offset) : base(data, offset) {
        // TODO: read properties from data
    }

    public override void OnEnter(Player player)
    {
        stored = player.Speed;
        player.Speed = player.Speed/2;
        player.StateMachine.State = 0;
    }
    public override void OnLeave(Player player)
    {
        player.Speed = stored + player.Speed;
        player.StateMachine.State = 0;
        RemoveSelf();
    }
}