local pigarithm = {}

local spriteOptions = {
    Small = "pigarithm_small",
    Medium = "pigarithm_medium",
    Big = "pigarithm_big",
}

pigarithm.name = "GameHelper/Pigarithm"
pigarithm.depth = 8998
pigarithm.minimumSize = { 16, 16 }
pigarithm.maximumSize = { 48, 32 }
pigarithm.canResize = { true, true }
pigarithm.fieldInformation = {
    sprite = {
        options = spriteOptions,
        editable = false
    }
}
pigarithm.placements = {
    {
        name = "pigarithm",
        data = {
            width = 48,
            height = 32,
            sprite = "pigarithm_big",
            speed = 60.0,
            startRight = true,
            kill = true,
            gravity = false,
            flipSprite = false,
            flag = ""
        }
    }
}

function pigarithm.justification(room, entity)
    local y = entity.flipSprite and 1.0 or 0.0
    if entity.sprite == "pigarithm_small" then
        return { 0.28, y }
    elseif entity.sprite == "pigarithm_medium" then
        return { 0.18, y }
    elseif entity.sprite == "pigarithm_big" then
        return { 0.14, y }
    end
end

function pigarithm.scale(room, entity)
    return { 1, entity.flipSprite and -1 or 1 }
end

function pigarithm.texture(room, entity)
    local sprite = string.sub(entity.sprite, 11)
    return "objects/GameHelper/pigarithm/" .. sprite .. "/idle"
end

return pigarithm
