local deadeline = getEntity("DialogNPC", "Celeste.Mod.DoonvHelper.Entities.")
local badeline
local level = getLevel()

function onBegin()
	disableMovement()
	if not getFlag("killedMadeline2") and not getFlag("sparedMadeline2") then
		deadeline.CutsceneModeEnabled = true
		walkTo(deadeline.Position.X - 15)
		player.Facing = getEnum("Celeste.Facings", "Right")
		wait(0.3)
		level.Displacement:AddBurst(player.Position, 0, 8, 32, 0.5)
		coroutine.yield(player:CreateSplitParticles())
		badeline = celeste.BadelineDummy(player.Position + vector2(8, -10))
		badeline.Sprite.Scale = vector2(1, 1)
		level:Add(badeline)
		wait(0.2)
		player.Facing = getEnum("Celeste.Facings", "Right")
		playSound("event:/char/badeline/maddy_split", player.Position)
		coroutine.yield(badeline:FloatTo(player.Position + vector2(40, -8), 1, false, false, true))
		badeline.Sprite.Scale = vector2(-1, 1)
		wait(0.1)
		
		say("CC_Aques_end00")
		if choice("CC_Aques_endChoiceA","CC_Aques_endChoiceB") == 1 then
			-- Leave her be
			setFlag("sparedMadeline2",true)
			say("CC_Aques_sparedMadeline")
			coroutine.yield(badeline:Vanish())
		else
			-- Kill her
			setFlag("redblackout",true)
			wait(0.75)
			playSound("event:/CC/CC_BrutalOrchestra/CC_MBO_JustALittleStab")
			wait(1)
			setFlag("killedMadeline2",true)
			playSound("event:/CC/CC_BrutalOrchestra/CC_MBO_JustALittleStab")
			wait(0.7)
			playSound("event:/CC/CC_BrutalOrchestra/CC_MBO_JustALittleStab")
			wait(0.8)
			playSound("event:/CC/CC_BrutalOrchestra/CC_MBO_JustALittleStab")
			wait(0.5)
			playSound("event:/CC/CC_BrutalOrchestra/CC_MBO_JustALittleStab")
			wait(0.25)
			playSound("event/char/madeline/death")
			wait(0.4)
			playSound("event:/CC/CC_BrutalOrchestra/CC_MBO_FallingBody")
			wait(0.4)
			miniTextbox("CC_Aques_end01")
			coroutine.yield(badeline:Vanish())
			wait(0.55)
			setFlag("redblackout",false)
		end
	elseif getFlag("killedMadeline2") then
		say("CC_Aques_endKilledMadeline")
	elseif getFlag("sparedMadeline2") then
		say("CC_Aques_end_normalMadelineInteraction")
	end
end

function onEnd(room, wasSkipped)
	deadeline.CutsceneModeEnabled = false
	enableMovement()
	setFlag("redblackout",false)
	if (wasSkipped) then
		setFlag("sparedMadeline2",true)
		coroutine.yield(badeline:Vanish())
	end
end