local function createNailCollider(func, collider)
  return celeste.Mod.CrossoverCollab.CrossoverCollabModule.CreateNailColliderDelegate(func, collider)
end

local function hurt()
    celeste.Mod.Kelper.Mechanics.Nail.NailRebound(0.5)
    celeste.Mod.Kelper.Mechanics.Nail.ConsumeSwing()
    if puppet.BossHitCooldown <= 0 and getFlag("HKBossChainsBroken") and not getFlag("hk_doing_suicide")  then
        helpers.decreaseHealth(1)
        resetHitCooldown()
        player:Play("event:/CC/CC_HollowKnight/SFX/Boss SFX/Damage") --Play hit/squish sound
    end
    return true
end

local function switchNailColliders()
    --log("switchnailcolliderlog")
    addComponentToBoss(createNailCollider(hurt))

    setFlag("hk_change_to_no_head", true)
    setFlag("hk_change_to_main", false)

    setFlag("hk_hitbox_main", false)
    setFlag("hk_hitbox_no_head", true)
    while true do
        if getFlag("hk_change_to_main") then
            if puppet.Facing < 0 then
                changeBaseHitboxTo("main")
            else
                changeBaseHitboxTo("main_left")
            end
            setFlag("hk_change_to_main", false)
            setFlag("hk_hitbox_main", true)
            setFlag("hk_hitbox_no_head", false)
            if puppet:SolidCollideCheck() then
                puppet:TryWiggle()
            end
        end
        if getFlag("hk_change_to_no_head") then
            changeBaseHitboxTo("no_head")
            setFlag("hk_change_to_no_head", false)
            setFlag("hk_hitbox_main", false)
            setFlag("hk_hitbox_no_head", true)
            if puppet:SolidCollideCheck() then
                puppet:TryWiggle()
            end
        end
        wait()
    end
end

local function healthTracking()
    --log("healthtrackinglog")
    setFlag("THKHealth", true)
    while getHealth() > 20 do
        wait()
    end

    -- phase 2
    helpers.setMusicProgression(1)
    startNextAttackPattern()

    while getHealth() > 10 do
        wait()
    end

    -- phase 3
    startNextAttackPattern()

    while getHealth() > 0 do
        wait()
    end
    disableCollisions()
    interruptPattern()
    startNextAttackPattern()
end


local function turnTowardsPlayer()
    --log("turntowardsplayerlog")
    while true do
        wait()
        waitForAttackToEnd()
        if getFlag("hk_can_turn") then
            local dir = puppet.Position.X - player.Position.X
            if dir > 0 then
                dir = 1
            else
                dir = -1
            end
            if getFlag("hk_hitbox_main") and puppet.Facing ~= dir then 
                setFlag("hk_change_to_main", true)
            end
            if getFlag("hk_hitbox_no_head") and puppet.Facing ~= dir then 
                setFlag("hk_change_to_no_head", true)
            end
            puppet.Facing = dir
        end
    end
end


function setup()
    helpers.setEffectiveGravityMult(0)
    --log("thksetup")
    puppet.Position = vector2(7800, -350) --vector2(7770, -275)
    playPuppetAnim("chained")
    helpers.changeKillColliderTo("empty")
    addConstantBackgroundCoroutine(switchNailColliders)
    addConstantBackgroundCoroutine(healthTracking)
    addConstantBackgroundCoroutine(turnTowardsPlayer)
    --log("thkendsetup")
end