local Audio = require("#Celeste.Audio")

local function getCircleAttack(offset)
    return getNewBasicAttackEntity(getRoomCoordinates() + vector2(offset), getCircle(15), "uumuuBall", false)
end

local function enableCircle(circle)
    circle.Collidable = true
end

local positions = {
    {
        {120, 672}, {264, 824}, {224, 560}, {64, 600}, {168, 464}
    },
    {
        {536, 760}, {336, 784}, {576, 544}, {384, 648}, {440, 736}
    },
    {
        {400, 840}, {568, 696}, {200, 728}, {112, 752}, {296, 448}
    },
    {
        {136, 544}, {280, 632}, {88, 424}, {536, 472}, {488, 656}
    },
    {
        {216, 376}, {384, 432}, {464, 392}, {360, 568}, {464, 528}
    }
}

function onBegin()
    setFlag("uumuu_slow", true)
    while not getFlag("uumuu_static") do wait() end
    
    --miniTextbox("attack_anim_sound")
    playPuppetAnim("attack")
	AttackSfx = celeste.SoundSource()
	addComponentToBoss(AttackSfx:Play("event:/CC/CC_HollowKnight/SFX/Boss SFX/UumuuZappingLoop"))
	--AttackSfx = Audio.Play("event:/CC/CC_HollowKnight/SFX/Boss SFX/UumuuZappingLoop", puppet.position)
    for _, t in ipairs(positions) do
        for _, v in ipairs(t) do
            local circleAttack = getCircleAttack(v)
            circleAttack:Add(getEntityTimer(1.5))
            circleAttack:Add(getEntityTimer(0.5, enableCircle))
            addEntity(circleAttack)
            wait(0.05) --3
        end
        wait(0.15) --9
    end
    wait(1)
	AttackSfx:Stop()
	--Audio.Stop(AttackSfx, false)
    playPuppetAnim("idle")
    setFlag("uumuu_follower", true)
    setFlag("uumuu_slow", false)
    wait(2)
end