-- NOTES:

-- Shade cloak cutscene [when enter the bowl in AB-07 statue, zoom in, play shadeCloak anim, collect custom collectible (shade cloak)]

local lua_helper = celeste.Mod.LuaCutscenes.LuaHelper

local function makeCoroutine(func)
	return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end

local function shadeCloakIfUpgradeCollected() -- checks if the upgrade has finished its collection on every frame
	while not getFlag("ShadeCloak") do
		wait()
		disableMovement()
	end
	-- when ShadeCloak is true, do the thing
	disableMovement()
end

function onBegin()
	disableMovement()
	disableRetry()
	getLevel().InCutscene = false
	wait(0.05)
	teleportTo(6176,6048)
	player.DummyAutoAnimate = false
	player.Sprite:Play("shadeCloak")
	wait(1)
	player.Sprite:Play("shadeCloakBlack")
	setFlag("ShadowCloakCollectableAppears",true)
	wait(0.25)
	getLevel().InCutscene = true
	wait(0.75)
end

function onEnd(room, wasSkipped)
	if wasSkipped then
		enableMovement()
	end
	enableMovement()
	getLevel().InCutscene = true
end