-- NOTES:

-- CC_XELK_CUTS_AB_D levitate Madeline off ground into spinning anim, zoom in,
-- play voidHeart anim frames 0-19, during which spawn black particles, stall on frame 19 as long as needed, play frames 20-25,
-- start whiteout on frame 21 and end whiteout one anim frame after frame 25 plays > wakeUp back in AB-08, collect custom collectible (void heart)]

function onBegin()
	disableMovement()
	setFlag("VoidHeartCutsceneC_Seen",true)
	player.ForceCameraUpdate = true
	waitUntilOnGround()
	wait(0.1)
	coroutine.yield(getLevel():ZoomTo(vector2(168, 40), 1.3, 0.8))
	walk(160)
	say("CC_XELK_CUTS_AB_D")
	for i=1,4 do
		setMusicLayer (i, false)
	end
	wait(0.75)

	--setFlag("VoidHeart_PlayerLevitating",true)
	local playerLevitate = celeste.Mod.CrossoverCollab.CrossoverCollabModule.PlayerSpeedCoroutine(player, -85)
	player:Add(playerLevitate)

	setCameraOffset(0,-1.5)
	disableRetry()
	player.DummyAutoAnimate = false
	player.DummyGravity = false
	player.Sprite:Play("spinFaster")
	wait(0.75) -- how long the player should move upwards
	coroutine.yield(getLevel():ZoomTo(vector2(168, -32), 1.45, 0.5))

	--setFlag("VoidHeart_PlayerLevitating",false)
	playerLevitate:RemoveSelf()

	player.Sprite:Play("voidHeart")

	--setFlag("VoidHeart_VoidLobby_BlackParticles",true)
	local playerFloat = celeste.Mod.CrossoverCollab.CrossoverCollabModule.PlayerSpeedCoroutine(player, 0)
	player:Add(playerFloat)

	wait(3)
	player.Sprite:Play("voidHeartBlack")
	wait(0.5) -- "stall on frame 19 as long as needed"
	player.Sprite:Play("voidHeartConsumed")
	setFlag("whiteFade",true)
	wait(0.8)
	player.Sprite:Play("wakeUp")

	--setFlag("VoidHeart_VoidLobby_BlackParticles",false)
	playerFloat:RemoveSelf()

	getLevel():ResetZoom()
	teleportTo(4578,6356,"AB-08")
end

function onEnd(room, wasSkipped)
	enableMovement()
	enableRetry()
	setFlag("blackFade",false)
	setFlag("VoidHeartCutsceneC_Seen",true)
	if wasSkipped then
		setFlag("whiteFade",true)
		getLevel():ResetZoom()
		teleportTo(4578,6356,"AB-08")
	end
end