--[[ FISHING MINIGAME
1) If you can fish, set fishingState = true
2) Check current pole and current fishingSpot
3) Determine a weighted random seed to determine catchType. Checks:
	- If (fishingSpot=lava && pole != lavaPole), catchType = nothing
	- If (bait < 1), catchType = (common || nothing)
4) Dot -> Random seed for waitingTime -> Random seed for "!" or "."
5) If ".", repeat up to 3 times
   If "!", wait time depending on catchType
6) If button press, set Catched flag, play sound, wait ~0.75s, unset Catched.
Determine fish type based on catchType and fishingSpot, and count =+1
If no button press, set Fleed flag, play sound, wait ~0.75s, unset Fleed.
7) Set fishingState = false and finish cutscene

QUEST REWARDS
40 coins < plant < lavaPole < mana crystal < sponge < goldenPole --]]



local lua_helper = celeste.Mod.LuaCutscenes.LuaHelper
local monocle = require("#monocle")
local celeste = require("#celeste")
local luaCutscenesUtils = require("#Celeste.Mod.MaxHelpingHand.Module.LuaCutscenesUtils")
local bettertext = require("#Celeste.Mod.CrossoverCollab.Code.PointsStuff.BetterTextbox")
local save = require("#Celeste.Mod.CrossoverCollab.Code.PointsStuff.PointsModule")
local exitIfPressed
local baitDiscount = 0

local fish = {seekerfish={count = 0, value = 3}, anglerFish={count = 0, value = 12}, fishOfCthulhu={count = 0, value = 28},		-- crimson
			  seaweed={count = 0, value = 1}, pleadfish={count = 0, value = 8}, jellyfish={count = 0, value = 25},				-- left beach
			  harpyfish={count = 0, value = 4}, cloudfish={count = 0, value = 10}, momtrout={count = 0, value = 32},				-- sky lake
			  lavaKoi={count = 0, value = 6}, demonicHellfish={count = 0, value = 12}, theoVoodooFish={count = 0, value = 32},	-- underworld
			  beeFish={count = 0, value = 5}, honeyfin={count = 0, value = 9}, goldfish={count = 0, value = 50},				-- hive
			  frostMinnow={count = 0, value = 3}, celesteFish={count = 0, value = 11}, mutantFlinxfin={count = 0, value = 30},	-- ice
			  rainbowAngelfish={count = 0, value = 100}, junk={count = 0, value = 0}}											-- special

local function makeCoroutine(func)
	return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end

local function exitIfPressedRoutine() -- checks if Grab/Interaction button is pressed on every frame
	while not (celeste.Input.Grab.Pressed or celeste.Input.Talk.Pressed or celeste.Input.MenuConfirm.Pressed or celeste.Input.MenuJournal.Pressed) do
		wait()
	end
	setFlag("grabPressed", true)
end

function onTalk()
	disableMovement()
	disableRetry()
-- PRECONDITIONS
	if (getFlag("Sponge") == false) and ((getFlag("hasPole") == true) or getFlag("betterPole") == true or getFlag("lavaPole") == true or getFlag("goldPole") == true) then
	-- Makes sure that sponge permabuff is not active and that player has some kind of pole
			if getFlag("lavaPole") == false and getFlag("goldPole") == false and getFlag("fishingSpotLava") == true then -- Try to fish on lava without improved poles
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_fish_cantfishonlava"))
				endCutscene()
			end
			player.DummyAutoAnimate = false
			-- TODO: re-implement if zoom gets fixed in Ex Camera Dynamics
			--coroutine.yield(engine.Scene:ZoomTo(vector2(160, 90), 1.2, 0.4)) -- zooms in
			if getLevel().Session.LevelData.Name == "Ocean4-13" then
				player.Facing = getEnum("Celeste.Facings", "Left")
			else
				player.Facing = getEnum("Celeste.Facings", "Right")
			end
			player.Sprite:Play("sitDown") -- plays animation
			wait(1.85)
			playSound("event:/CC/CC_KoseiDiamond_sounds/fishing")
			wait(0.15)
			setFlag("grabPressed", false)
			engine.Scene.Session:SetCounter("TotalFishingAttempts", engine.Scene.Session:GetCounter("TotalFishingAttempts") + 1)
			setFlag("fishingState", true) -- fishing minigame starts
			if getFlag("baitPermabuff") then
				setFlag("superFishingState", true)
			end
			if GetFishAmount("bait") == 1 then
				setFlag("showBait1",true)
			end
			if GetFishAmount("bait") == 2 then
				setFlag("showBait1",true)
				setFlag("showBait2",true)
			end
			if GetFishAmount("bait") == 3 then
				setFlag("showBait1",true)
				setFlag("showBait2",true)
				setFlag("showBait3",true)
			end
			talker:Add(makeCoroutine(exitIfPressedRoutine))
			randomTime()
			fishWait()
	elseif (getFlag("Sponge") == true) then
		coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_fish_sponge"))
	elseif (getFlag("hasPole") == false) then
		coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_fish_nopole"))
	end
end

function caught()
	setFlag("fishingCaught",true)
	playSound("event:/classic/sfx55")
	fishSelection()
	math.randomseed(engine.Scene.Session:GetCounter("TotalFishingAttempts") + getLevel().Session.Deaths * 37 + 1 + GetFishAmount("totalFishesCaught"))
	fish[n].count = fish[n].count + 1
	wait(1.75)
	endCutscene()
end

function fled()
	setFlag("fishingFled",true)
	playSound("event:/CC/CC_KoseiDiamond_sounds/fishing_escape")
	setFlag("fishingDot1",false)
	setFlag("fishingDot2",false)
	setFlag("fishingDot3",false)
	setFlag("fishingDot4",false)
	setFlag("fishingExclamation2",false)
	setFlag("fishingExclamation3",false)
	setFlag("fishingExclamation4",false)
	wait(0.75)
	endCutscene()
end

function fishWait() -- controls the time needed to wait between each dot/exclamation
	waitOrGrab(waitingTime + 0.25) -- waits between 0.25 and 3.25 seconds
	playSound("event:/classic/sfx2")
	setFlag("fishingDot1",true)
	randomTime()
	waitOrGrab(waitingTime + 0.25) -- waits between 0.25 and 3.25 seconds
	isExclamation = math.random(0,5) + math.random() -- 0,5 generates int between 0 and 5 and math.random() generates a float. don't ask
	if (isExclamation <=0.5 and not getFlag("grabPressed")) then
		playSound("event:/classic/sfx2")
		setFlag("fishingDot2",true)
		randomTime()
		waitOrGrab(waitingTime + 0.25) -- waits between 0.25 and 3.25 seconds
		isExclamation = math.random(0,5) + math.random()
		if (isExclamation <=0.5 and not getFlag("grabPressed")) then
			playSound("event:/classic/sfx2")
			setFlag("fishingDot3",true)
			randomTime()
			waitOrGrab(waitingTime + 0.25) -- waits between 0.25 and 3.25 seconds
			isExclamation = 0 -- last one should always be an exclamation
			if (isExclamation <=0.5 and not getFlag("grabPressed")) then
				playSound("event:/classic/sfx2")
				setFlag("fishingDot4",true)
			else
				if not getFlag("grabPressed") then
					goingToFlee(4)
				else
					fled()
				end
			end
		else
			if not getFlag("grabPressed") then
				goingToFlee(3)
			else
				fled()
			end
		end
	else
		if not getFlag("grabPressed") then
			goingToFlee(2)
		else
			fled()
		end
	end
end

function waitOrGrab(maxTime)
    local elapsed = 0
    local step = 0.05
    while elapsed < maxTime do
        if getFlag("grabPressed") then
            return true -- grabbed early
        end
        wait(step)
        elapsed = elapsed + step
    end
    return false -- no grab
end

function goingToFlee(exclamationNumber)
	if exclamationNumber == 4 then
		setFlag("fishingExclamation4",true)
	elseif exclamationNumber == 3 then
		setFlag("fishingExclamation3",true)
	elseif exclamationNumber == 2 then
		setFlag("fishingExclamation2",true)
	end
	
	
	math.randomseed(engine.Scene.Session:GetCounter("TotalFishingAttempts") + getLevel().Session.Deaths * 37 + 1)
	waitBeforeFlee = math.random()
	waitBait = 0
	if GetFishAmount("bait") > 0 then
		waitBait = 0.25
	end
	wait(waitBeforeFlee + 0.15 + waitBait) -- Time to wait before fleeing
	

	if getFlag("grabPressed") == false then
		fled()
	else
		caught()
	end
end

local rngInitialized = false

function randomTime() -- returns a random number between 0 and 3. bait slightly increases wait time
		math.randomseed(engine.Scene.Session:GetCounter("TotalFishingAttempts") + getLevel().Session.Deaths * 37 + 1 + engine.Scene.Session:GetCounter("KoseiHelper_timesJumpedCounter"))
		waitingTimeA = math.random()
		math.randomseed(engine.Scene.Session:GetCounter("TotalFishingAttempts") + getLevel().Session.Deaths * 37 + 1 + engine.Scene.Session:GetCounter("KoseiHelper_timesDashedCounter"))
		waitingTimeB = math.random()
		math.randomseed(engine.Scene.Session:GetCounter("TotalFishingAttempts") + getLevel().Session.Deaths * 37 + 1 + engine.Scene.Session:GetCounter("KoseiHelper_timesJumpedCounterWall"))
		waitingTimeC = math.random()
		waitingTime = waitingTimeA + waitingTimeB + waitingTimeC
		-- normalizes values so you never have to wait 3 seconds and have some time to react always
		if waitingTime > 2 then
			waitingTime = 2
		elseif waitingTime < 0.2 then
			waitingTime = 0.2
		end
		if (waitingTime <= 2.9) and (GetFishAmount("bait") == 1) then
			waitingTime = waitingTime + 0.1
		end
		if (waitingTime <= 2.8) and (GetFishAmount("bait") == 2) then
			waitingTime = waitingTime + 0.2
		end
		if (waitingTime <= 2.7) and (GetFishAmount("bait") == 3) then
			waitingTime = waitingTime + 0.3
		end
		return waitingTime
end

function fishSelection()
	math.randomseed(engine.Scene.Session:GetCounter("TotalFishingAttempts") + getLevel().Session.Deaths * 37 + 1 + engine.Scene.Session:GetCounter("KoseiHelper_timesJumpedCounterWallbounce"))
	fishNumber = math.random() -- calculates number between 0 and 1 to determine fish caught. Improved poles or bait give a small bonus to catch rarer fishes. Penalizes having no bait.
	if GetFishAmount("bait") == 0 then
		fishNumber = fishNumber - 0.08
	end
	if GetFishAmount("bait") == 1 then
		fishNumber = fishNumber + 0.02
	end
	if GetFishAmount("bait") == 2 then
		fishNumber = fishNumber + 0.02
	end
	if GetFishAmount("bait") == 3 then
		fishNumber = fishNumber + 0.02
	end
	
	if getFlag("goodPole") then
		fishNumber = fishNumber + 0.03
	end
	if getFlag("lavaPole") then
		fishNumber = fishNumber + 0.06
	end
		if getFlag("goldenPole") then
		fishNumber = fishNumber + 0.1
	end
	log("You have caught something! The fish was determined by the number: " .. fishNumber)
	baitConsumed = math.random()
	-- Calculates chance of losing a bait: 20% normal pole, 15% better pole, 10% lava pole, 5% golden pole
	if getFlag("betterPole") then
		baitDiscount = 0.05
	end
	if getFlag("lavaPole") then
		baitDiscount = 0.1
	end
	if getFlag("goldenPole") then
		baitDiscount = 0.15
	end
	if getFlag("baitPermabuff") then
		baitDiscount = baitDiscount + 0.05
	end
	
	if baitConsumed <= (0.20 - baitDiscount) and (GetFishAmount("bait") > 0) then  -- Determines chance of consuming bait, and checks that there is at least 1 bait in inventory
		if (getFlag("showBait1") or getFlag("showBait2") or getFlag("showBait3")) then -- Double checks that you have a bait before removing it (i.e. you didn't alter the flags!)
			AddFish("bait",-1)
			playSound("event:/CC/CC_KoseiDiamond_sounds/fishing_bait")
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_fish_consumedBait"))
		end
		if GetFishAmount("bait") == 3 then
			setFlag("showBait3",false)
		elseif GetFishAmount("bait") == 2 then
			setFlag("showBait2",false)
		elseif GetFishAmount("bait") == 1 then
			setFlag("showBait1",false)
		end
	end
	
	
	if getFlag("fishingSpotCrimson") then
		if (fishNumber <= 0.6) then
			setFlag("seekerfish",true)
			MaybeDoubleFish("seekerfish")
			wait()
			bettersay("[MADELINE normal right]I caught a Seekerfish!{n}I now have a total of {#b227fd}"..tostring(GetFishAmount("seekerfish")).."{#} seekerfish.")
		elseif (fishNumber > 0.6 and fishNumber <= 0.88) and (getFlag("goodPole") or getFlag("lavaPole") or getFlag("goldenPole")) then
			setFlag("anglerFish",true)
			MaybeDoubleFish("anglerFish")
			wait()
			bettersay("[MADELINE normal right]I caught an Angler fish!{n}I now have a total of {#b227fd}"..tostring(GetFishAmount("anglerFish")).."{#} angler fish.")
		elseif (fishNumber > 0.88) and (getFlag("lavaPole") or getFlag("goldenPole")) then
			setFlag("fishOfCthulhu",true)
			MaybeDoubleFish("fishOfCthulhu")
			wait()
			bettersay("[MADELINE normal right]I caught a Fish Of Cthulhu!{n}I now have a total of {#b227fd}"..tostring(GetFishAmount("fishOfCthulhu")).."{#} fish of Cthulhu.")
		elseif (fishNumber > 1.09) and getFlag("goldenPole") then
			setFlag("rainbowAngelfish",true)
			MaybeDoubleFish("rainbowAngelfish")
			wait()
			bettersay("[MADELINE normal surprised]Wow! I got a Rainbow Angelfish!{n}I now have a total of {#b227fd}"..tostring(GetFishAmount("rainbowAngelfish")).."{#} rainbow angelfish.")
		else
			setFlag("junk",true)
			AddFish("junk",1)
			wait()
			if GetFishAmount("junk") < 2 then
				bettersay("[MADELINE upset right]Uh... Who throws  {#b227fd}useless junk{#} here? I can't even sell it!")
			else
				bettersay("[MADELINE upset right]Bruh. I've found junk like {#b227fd}"..tostring(GetFishAmount("junk")).."{#} times already!")
			end
		end
		
	elseif getFlag("fishingSpotOcean") then
		if (fishNumber <= 0.71) then
			setFlag("seaweed",true)
			MaybeDoubleFish("seaweed")
			wait()
			bettersay("[MADELINE normal right]I caught a Seaweed!{n}I now have a total of {#b227fd}"..tostring(GetFishAmount("seaweed")).."{#} seaweeds.")
		elseif (fishNumber > 0.71 and fishNumber <= 0.87) and (getFlag("goodPole") or getFlag("lavaPole") or getFlag("goldenPole")) then
			setFlag("pleadfish",true)
			MaybeDoubleFish("pleadfish")
			wait()
			bettersay("[MADELINE normal right]I caught a Pleadfish!{n}I now have a total of {#b227fd}"..tostring(GetFishAmount("pleadfish")).."{#} pleadfish.")
		elseif (fishNumber > 0.87) and (getFlag("lavaPole") or getFlag("goldenPole")) then
			setFlag("jellyfish",true)
			MaybeDoubleFish("jellyfish")
			wait()
			bettersay("[MADELINE normal right]I caught a Jellyfish!{n}I now have a total of {#b227fd}"..tostring(GetFishAmount("jellyfish")).."{#} jellyfish.")
		elseif (fishNumber > 1.09) and getFlag("goldenPole") then
			setFlag("rainbowAngelfish",true)
			MaybeDoubleFish("rainbowAngelfish")
			wait()
			bettersay("[MADELINE normal surprised]Wow! I got a Rainbow Angelfish!{n}I now have a total of {#b227fd}"..tostring(GetFishAmount("rainbowAngelfish")).."{#} rainbow angelfish.")
		else
			setFlag("junk",true)
			AddFish("junk",1)
			wait()
			if GetFishAmount("junk") < 2 then
				bettersay("[MADELINE upset right]Uh... Who throws  {#b227fd}useless junk{#} here? I can't even sell it!")
			else
				bettersay("[MADELINE upset right]Bruh. I've found junk like {#b227fd}"..tostring(GetFishAmount("junk")).."{#} times already!")
			end
		end
		
	elseif getFlag("fishingSpotSky") then
		if (fishNumber <= 0.675) then
			setFlag("harpyfish",true)
			MaybeDoubleFish("harpyfish")
			wait()
			bettersay("[MADELINE normal right]I caught a Harpyfish!{n}I now have a total of {#b227fd}"..tostring(GetFishAmount("harpyfish")).."{#} harpyfish.")
		elseif (fishNumber > 0.675 and fishNumber <= 0.9) and (getFlag("goodPole") or getFlag("lavaPole") or getFlag("goldenPole")) then
			setFlag("cloudfish",true)
			MaybeDoubleFish("cloudfish")
			wait()
			bettersay("[MADELINE normal right]I caught a Cloudfish!{n}I now have a total of {#b227fd}"..tostring(GetFishAmount("cloudfish")).."{#} cloudfish.")
		elseif (fishNumber > 0.9) and (getFlag("lavaPole") or getFlag("goldenPole")) then
			setFlag("momtrout",true)
			MaybeDoubleFish("momtrout")
			wait()
			bettersay("[MADELINE normal right]I caught a Momtrout!{n}I now have a total of {#b227fd}"..tostring(GetFishAmount("momtrout")).."{#} momtrouts.")
		elseif (fishNumber > 1.09) and getFlag("goldenPole") then
			setFlag("rainbowAngelfish",true)
			MaybeDoubleFish("rainbowAngelfish")
			wait()
			bettersay("[MADELINE normal surprised]Wow! I got a Rainbow Angelfish!{n}I now have a total of {#b227fd}"..tostring(GetFishAmount("rainbowAngelfish")).."{#} rainbow angelfish.")
		else
			setFlag("junk",true)
			AddFish("junk",1)
			wait()
			if GetFishAmount("junk") < 2 then
				bettersay("[MADELINE upset right]Uh... Who throws  {#b227fd}useless junk{#} here? I can't even sell it!")
			else
				bettersay("[MADELINE upset right]Bruh. I've found junk like {#b227fd}"..tostring(GetFishAmount("junk")).."{#} times already!")
			end
		end
		
	elseif getFlag("fishingSpotLava") then -- requires lava pole to be able to fish here
		if fishNumber <= 0.55 and (getFlag("lavaPole") or getFlag("goldenPole")) then
			setFlag("lavaKoi",true)
			MaybeDoubleFish("lavaKoi")
			wait()
			bettersay("[MADELINE normal right]I caught a Lava Koi!{n}I now have a total of {#b227fd}"..tostring(GetFishAmount("lavaKoi")).."{#} lava kois.")
		elseif (fishNumber > 0.55 and fishNumber <= 0.93) and (getFlag("lavaPole") or getFlag("goldenPole")) then
			setFlag("demonicHellfish",true)
			MaybeDoubleFish("demonicHellfish")
			wait()
			bettersay("[MADELINE normal right]I caught a Demonic Hellfish!{n}I now have a total of {#b227fd}"..tostring(GetFishAmount("demonicHellfish")).."{#} demonic hellfish.")
		elseif (fishNumber > 0.93) and (getFlag("lavaPole") or getFlag("goldenPole")) then
			setFlag("theoVoodooFish",true)
			MaybeDoubleFish("theoVoodooFish")
			wait()
			bettersay("[MADELINE normal right]I caught a Theo Voodoo Fish!{n}I now have a total of {#b227fd}"..tostring(GetFishAmount("theoVoodooFish")).."{#} Theo voodoo fish.")
		elseif (fishNumber > 1.09) and getFlag("goldenPole") then
			setFlag("rainbowAngelfish",true)
			MaybeDoubleFish("rainbowAngelfish")
			wait()
			bettersay("[MADELINE normal surprised]Wow! I got a Rainbow Angelfish!{n}I now have a total of {#b227fd}"..tostring(GetFishAmount("rainbowAngelfish")).."{#} rainbow angelfish.")
		else
			setFlag("junk",true)
			AddFish("junk",1)
			wait()
			if GetFishAmount("junk") < 2 then
				bettersay("[MADELINE upset right]Uh... Who throws  {#b227fd}useless junk{#} here? I can't even sell it!")
			else
				bettersay("[MADELINE upset right]Bruh. I've found junk like {#b227fd}"..tostring(GetFishAmount("junk")).."{#} times already!")
			end
		end
		
	elseif getFlag("fishingSpotHoney") then -- requires improving pole at least once to fish something
		if (fishNumber <= 0.7) and (getFlag("betterPole") or getFlag("lavaPole") or getFlag("goldenPole")) then
			setFlag("beeFish",true)
			MaybeDoubleFish("beeFish")
			wait()
			bettersay("[MADELINE normal right]I caught a Bee Fish!{n}I now have a total of {#b227fd}"..tostring(GetFishAmount("beeFish")).."{#} bee fish.")
		elseif fishNumber <= 0.7 then
			setFlag("junk",true)
			AddFish("junk",1)
			wait()
			if GetFishAmount("junk") < 2 then
				bettersay("[MADELINE upset right]Uhm... It looks like I won't be able to get any fish with this pole here. And who throws {#b227fd}useless junk{#} here? I can't even sell it!")
			else
				bettersay("[MADELINE upset right]Uhm... It looks like I won't be able to get any fish with this pole here. And I've found junk like {#b227fd}"..tostring(GetFishAmount("junk")).."{#} times already!")
			end
		elseif (fishNumber > 0.7 and fishNumber <= 0.96) and (getFlag("goodPole") or getFlag("lavaPole") or getFlag("goldenPole")) then
			setFlag("honeyfin",true)
			MaybeDoubleFish("honeyfin")
			wait()
			bettersay("[MADELINE normal right]I caught a Honeyfin!{n}I now have a total of {#b227fd}"..tostring(GetFishAmount("honeyfin")).."{#} honeyfins.")
		elseif (fishNumber > 0.96) and (getFlag("lavaPole") or getFlag("goldenPole")) then
			setFlag("goldfish",true)
			MaybeDoubleFish("goldfish")
			wait()
			bettersay("[MADELINE normal right]I caught a Goldfish!{n}I now have a total of {#b227fd}"..tostring(GetFishAmount("goldfish")).."{#} goldfish.")
		elseif (fishNumber > 1.09) and getFlag("goldenPole") then
			setFlag("rainbowAngelfish",true)
			MaybeDoubleFish("rainbowAngelfish")
			wait()
			bettersay("[MADELINE normal surprised]Wow! I got a Rainbow Angelfish!{n}I now have a total of {#b227fd}"..tostring(GetFishAmount("rainbowAngelfish")).."{#} rainbow angelfish.")
		else
			setFlag("junk",true)
			AddFish("junk",1)
			wait()
			if GetFishAmount("junk") < 2 then
				bettersay("[MADELINE upset right]Uh... Who throws  {#b227fd}useless junk{#} here? I can't even sell it!")
			else
				bettersay("[MADELINE upset right]Bruh. I've found junk like {#b227fd}"..tostring(GetFishAmount("junk")).."{#} times already!")
			end
		end
		
	elseif getFlag("fishingSpotIce") then
		if (fishNumber <= 0.55) then
			setFlag("frostMinnow",true)
			MaybeDoubleFish("frostMinnow")
			wait()
			bettersay("[MADELINE normal right]I caught a Frost Minnow!{n}I now have a total of {#b227fd}"..tostring(GetFishAmount("frostMinnow")).."{#} frost minnows.")
		elseif (fishNumber > 0.55 and fishNumber <= 0.86) and (getFlag("goodPole") or getFlag("lavaPole") or getFlag("goldenPole")) then
			setFlag("celesteFish",true)
			MaybeDoubleFish("celesteFish")
			wait()
			bettersay("[MADELINE normal right]I caught a Celeste Fish!{n}I now have a total of {#b227fd}"..tostring(GetFishAmount("celesteFish")).."{#} celeste fish.")
		elseif (fishNumber > 0.86) and (getFlag("lavaPole") or getFlag("goldenPole")) then
			setFlag("mutantFlinxfin",true)
			MaybeDoubleFish("mutantFlinxfin")
			wait()
			bettersay("[MADELINE normal right]I caught a Mutant Flinxfin!{n}I now have a total of {#b227fd}"..tostring(GetFishAmount("mutantFlinxfin")).."{#} mutant flinxfins.")
		elseif (fishNumber > 1.09) and getFlag("goldenPole") then
			setFlag("rainbowAngelfish",true)
			MaybeDoubleFish("rainbowAngelfish")
			wait()
			bettersay("[MADELINE normal surprised]Wow! I got a Rainbow Angelfish!{n}I now have a total of {#b227fd}"..tostring(GetFishAmount("rainbowAngelfish")).."{#} rainbow angelfish.")
		else
			setFlag("junk",true)
			AddFish("junk",1)
			wait()
			if GetFishAmount("junk") < 2 then
				bettersay("[MADELINE upset right]Uh... Who throws  {#b227fd}useless junk{#} here? I can't even sell it!")
			else
				bettersay("[MADELINE upset right]Bruh. I've found junk like {#b227fd}"..tostring(GetFishAmount("junk")).."{#} times already!")
			end
		end
	end
end

function MaybeDoubleFish(fishName)
    local count = 1
    if getFlag("goldenPole") and math.random() <= 0.20 then
        count = 2
        playSound("event:/game/general/seed_complete_berry")
        bettersay("[MADELINE right normal]Lucky me! I caught {#b227fd}two "..fishName.."{#} at once!")
		endCutscene()
    end
    AddFish(fishName, count)
    AddFish("totalFishesCaught", count)
end

-- Adds a fish with any name, if that fish already exists, adds that many of it
function AddFish(name, amount)
    save.SaveData:AddFish(name, tonumber(amount))
 end
 -- Returns how many fish of that type you have
function GetFishAmount(name)
    return tonumber(save.SaveData:GetFishAmount(name))
end

function bettersay(dialog)
    coroutine.yield(bettertext.Say(tostring(dialog)))
end

function onEnd() -- finishes the cutscene. this is already a coroutine itself
	getLevel():ResetZoom()
	
	setFlag("seekerfish",false)
	setFlag("anglerFish",false)
	setFlag("fishOfCthulhu",false)
	
	setFlag("seaweed",false)
	setFlag("pleadfish",false)
	setFlag("jellyfish",false)
	
	setFlag("harpyfish",false)
	setFlag("cloudfish",false)
	setFlag("momtrout",false)
	
	setFlag("lavaKoi",false)
	setFlag("demonicHellfish",false)
	setFlag("theoVoodooFish",false)
	
	setFlag("beeFish",false)
	setFlag("honeyfin",false)
	setFlag("goldfish",false)
	
	setFlag("frostMinnow",false)
	setFlag("celesteFish",false)
	setFlag("mutantFlinxfin",false)
	
	setFlag("rainbowAngelfish",false)
	setFlag("junk",false)
	
	setFlag("showBait1",false)
	setFlag("showBait2",false)
	setFlag("showBait3",false)
	
	setFlag("fishingDot1",false)
	setFlag("fishingDot2",false)
	setFlag("fishingDot3",false)
	setFlag("fishingDot4",false)
	setFlag("fishingExclamation2",false)
	setFlag("fishingExclamation3",false)
	setFlag("fishingExclamation4",false)
	setFlag("fishingState",false)
	setFlag("superFishingState",false)
	setFlag("fishingCaught",false)
	setFlag("fishingFled",false)
	setFlag("grabPressed", false)
	player.DummyAutoAnimate = true
	enableMovement()
	enableRetry()
end