local luaCutscenesUtils = require("#Celeste.Mod.MaxHelpingHand.Module.LuaCutscenesUtils")
local bettertext = require("#Celeste.Mod.CrossoverCollab.Code.PointsStuff.BetterTextbox")
local save = require("#Celeste.Mod.CrossoverCollab.Code.PointsStuff.PointsModule")
local berchant = getEntity("DialogNPC", "Celeste.Mod.DoonvHelper.Entities.")

function onBegin()
	disableMovement()
	makeUnskippable()
	disableRetry()
	berchant.CutsceneModeEnabled = true
	math.randomseed(os.time())
	greeting = math.random(0,2)
	playSound("event:/CC/CC_KoseiDiamond/ui_pause")
	
	if not (getFlag("berchantFirstTalk") == true) then
		coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_firstTime"))
		setFlag("berchantFirstTalk", true)
		endCutscene()
	else -- GREETINGS
		if getFlag("cryoGoldenRun") then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_golden"))
		else
			if getFlag("PartyCenter") then
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_party"))
			else
				if getFlag("weatherRain") then
					if greeting == 0 then
						coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_greetingsD"))
					elseif greeting == 1 then
						coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_greetingsE"))
					elseif greeting == 2 then
						coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_greetingsF"))
					end
				elseif greeting == 0 then
					coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_greetingsA"))
				elseif greeting == 1 then
					coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_greetingsB"))
				elseif greeting == 2 then
					coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_greetingsC"))
				end
			end
		end
	end
	

	-- What do you want
	
	coroutine.yield(luaCutscenesUtils.ChoiceWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_sellFish", "CC_KoseiDiamond_berchant_buysomething", "CC_KoseiDiamond_berchant_nothing"))
	if luaCutscenesUtils.GetChoice() == 1 then -- sell confirmation
		if paymentFish() == 0 then
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_sellNothing"))
				endCutscene()
		end	
		bettersay("You will be paid {#F94A4A}"..tostring(paymentFish()).. "{#} terracoins. Are you sure?")
		coroutine.yield(luaCutscenesUtils.ChoiceWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_sellYes", "CC_KoseiDiamond_berchant_sellNo"))
		if luaCutscenesUtils.GetChoice() == 1 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_soldFish"))
			playSound("event:/CC/CC_KoseiDiamond_sounds/terracoin")
			AddFish("terracoins", paymentFish())
			if getFlag("Midas") == true then
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_midas"))
			end
			noMoreFishes()
			endCutscene()
		elseif luaCutscenes.Utils.GetChoice() == 2 then
			math.randomseed(os.time())
			bye = bye.random(0,3)
			if bye == 0 then
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_byeA"))
			elseif bye == 1 then
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_byeB"))
			elseif bye == 2 then
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_byeC"))
			else
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_byeD"))
			end
			endCutscene()
		end
		
		
	-- THE SHOPPING HAS BEGUN
		
	elseif luaCutscenesUtils.GetChoice() == 2 then -- shop menu
		bettersay("You have {#F94A4A}"..tostring(GetFishamount("terracoins")).. "{#} terracoins currently.")
	
		local buying = choice("CC_KoseiDiamond_berchant_buy1", "CC_KoseiDiamond_berchant_buy2", "CC_KoseiDiamond_berchant_buy3", "CC_KoseiDiamond_berchant_buy4", "CC_KoseiDiamond_berchant_buy5", "CC_KoseiDiamond_berchant_buy6", "CC_KoseiDiamond_berchant_buy7", "CC_KoseiDiamond_berchant_buy8", "CC_KoseiDiamond_berchant_buy9", "CC_KoseiDiamond_berchant_buy10", "CC_KoseiDiamond_berchant_buy11", "CC_KoseiDiamond_berchant_buyNone")
		-- bait, celeste, plant, good pole, fish warp or more
		if buying == 1 then -- bait
			if GetFishamount("terracoins") >=20 then
				if GetFishamount ("bait") <=2 then
					AddFish("terracoins", -20)
					AddFish("bait", 1)
					playSound("event:/CC/CC_KoseiDiamond_sounds/terracoin")
					if GetFishamount ("bait") <=1 then
						coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_moreBaitRecommended"))
					end
				else
					coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_buy1NoMoreBait"))
				end
			else
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_noMoney"))
			end
			
		elseif buying == 2 then -- celeste
			if GetFishamount("terracoins") >=40 then
				if getFlag("celesteItemPackBought") == false then
					AddFish("terracoins", -40)
					playSound("event:/CC/CC_KoseiDiamond_sounds/terracoin")
					setFlag("celesteItemPackBought",true)
				else
					coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_boughtAlready"))
				end
			else
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_noMoney"))
			end
			
		elseif buying == 3 then -- plant
			if GetFishamount("terracoins") >=100 then
				if not getFlag("plantBought") then
					AddFish("terracoins", -100)
					playSound("event:/CC/CC_KoseiDiamond_sounds/terracoin")
					coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_boughtSomething"))
					playSound("event:/game/general/seed_complete_berry")
					wait(0.1)
					setFlag("plantBought",true)
				else
					coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_boughtAlready"))
				end
			else
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_noMoney"))
			end
			
		elseif buying == 4 then -- good pole
			if GetFishamount("terracoins") >=180 then
				if not getFlag("goodPoleBought") then
					if getFlag("hasPole") then
						AddFish("terracoins", -180)
						playSound("event:/CC/CC_KoseiDiamond_sounds/terracoin")
						coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_boughtSomething"))
						playSound("event:/game/general/seed_complete_berry")
						wait(0.1)
						setFlag("goodPoleBought",true)
					else
						coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_noPoleForYou"))
					end
				else
					coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_boughtAlready"))
				end
			else
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_noMoney"))
			end
			
		elseif buying == 5 then -- fish warp machine
			if GetFishamount("terracoins") >=500 then
				if not getFlag("fishWarpBought") then
					AddFish("terracoins", -500)
					playSound("event:/CC/CC_KoseiDiamond_sounds/terracoin")
					coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_boughtSomething"))
					playSound("event:/game/general/seed_complete_berry")
					setFlag("fishWarpBought",true)
					coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_boughtFishingStations"))
				else
					coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_boughtAlready"))
				end
			else
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_noMoney"))
			end
			
		elseif buying == 6 then -- torches
			if GetFishamount("terracoins") >=10 then
				if engine.Scene.Session:GetCounter("TorchesLeft") < 201 then
					AddFish("terracoins", -10)
					playSound("event:/CC/CC_KoseiDiamond_sounds/terracoin")
					coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_boughtTourches"))
					engine.Scene.Session:SetCounter("TorchesLeft", engine.Scene.Session:GetCounter("TorchesLeft") + 100)
				else
					coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_boughtAllTorches"))
				end
			else
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_noMoney"))
			end
			
		-- monoliths, world globe, echo chamber, party center, music box or none
		
		elseif buying == 7 then
			local buyingMonoliths = choice("CC_KoseiDiamond_berchant_buy7_Nebula", "CC_KoseiDiamond_berchant_buy7_Solar", "CC_KoseiDiamond_berchant_buy7_StarDust", "CC_KoseiDiamond_berchant_buy7_Vortex", "CC_KoseiDiamond_berchant_buyNone")
			if buyingMonoliths == 1 then -- nebula
				if GetFishamount("terracoins") >= 400 then
					if not getFlag("NebulaBought") then
						AddFish("terracoins", -400)
						playSound("event:/CC/CC_KoseiDiamond_sounds/terracoin")
						coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_boughtSomething"))
						setFlag("NebulaBought", true)
						coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_buy7_bought"))
					else
						coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_boughtAlready"))
					end
				else
					coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_noMoney"))
				end
					
			elseif buyingMonoliths == 2 then -- solar
				if GetFishamount("terracoins") >= 400 then
					if not getFlag("SolarBought") then
						AddFish("terracoins", -400)
						playSound("event:/CC/CC_KoseiDiamond_sounds/terracoin")
						coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_boughtSomething"))
						setFlag("SolarBought", true)
						coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_buy7_bought"))
					else
						coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_boughtAlready"))
					end
				else
					coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_noMoney"))
				end
			
			elseif buyingMonoliths == 3 then -- stardust
				if GetFishamount("terracoins") >= 400 then
					if not getFlag("StarDustBought") then
						AddFish("terracoins", -400)
						playSound("event:/CC/CC_KoseiDiamond_sounds/terracoin")
						coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_boughtSomething"))
						setFlag("StarDustBought", true)
						coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_buy7_bought"))
					else
						coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_boughtAlready"))
					end
				else
					coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_noMoney"))
				end
			
			elseif buyingMonoliths == 4 then -- vortex
				if GetFishamount("terracoins") >= 400 then
					if not getFlag("VortexBought") then
						AddFish("terracoins", -400)
						playSound("event:/CC/CC_KoseiDiamond_sounds/terracoin")
						coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_boughtSomething"))
						setFlag("VortexBought", true)
						coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_buy7_bought"))
					else
						coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_boughtAlready"))
					end
				else
					coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_noMoney"))
				end
				
			elseif luaCutscenesUtils.GetChoice() == 5 then -- nothing
				math.randomseed(os.time())
				bye = bye.random(0,2)
				if bye == 0 then
					coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_byeA"))
				elseif bye == 1 then
					coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_byeB"))
				else
					coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_byeC"))
				end
			end

		elseif buying == 8 then -- world globe
			if GetFishamount("terracoins") >=200 then
				if not getFlag("WorldGlobeBought") then
					AddFish("terracoins", -200)
					playSound("event:/CC/CC_KoseiDiamond_sounds/terracoin")
					coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_boughtSomething"))
					setFlag("WorldGlobeBought", true)
					coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_buy7_bought"))
				else
					coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_boughtAlready"))
				end
			else
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_noMoney"))
			end

		elseif buying == 9 then -- echo chamber
			if GetFishamount("terracoins") >= 180 then
				if not getFlag("EchoChamberBought") then
					AddFish("terracoins", -180)
					playSound("event:/CC/CC_KoseiDiamond_sounds/terracoin")
					coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_boughtSomething"))
					setFlag("EchoChamberBought", true)
					coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_buy7_bought"))
				else
					coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_boughtAlready"))
				end
				
			else
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_noMoney"))
			end
			
		elseif buying == 10 then -- party center
			if GetFishamount("terracoins") >= 500 then
				if not getFlag("PartyCenterBought") then
					AddFish("terracoins", -500)
					playSound("event:/CC/CC_KoseiDiamond_sounds/terracoin")
					coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_boughtSomething"))
					setFlag("PartyCenterBought", true)
					coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_buy7_bought"))
				else
					coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_boughtAlready"))
				end
			else
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_noMoney"))
			end
			
		elseif buying == 11 then -- music box
			if GetFishamount("terracoins") >=220 then 
				if not getFlag("musicBoxBought") then
					AddFish("terracoins", -220)
					playSound("event:/CC/CC_KoseiDiamond_sounds/terracoin")
					coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_boughtSomething"))
					playSound("event:/game/general/seed_complete_berry")
					setFlag("musicBoxBought",true)
					coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_bought2"))
				else
					coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_boughtAlready"))
				end
			else
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_noMoney"))
			end
			
		elseif buying == 12 then -- nothing
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_berchant_byeB"))
		end
	end
end

-- Adds a fish with any name, if that fish already exists, adds that many of it
function AddFish(name, amount)
    save.SaveData:AddFish(name, tonumber(amount))
 end
-- Returns how many fish of that type you have (or coins)
function GetFishamount(name)
    return tonumber(save.SaveData:GetFishAmount(name))
end

function bettersay(dialog)
    coroutine.yield(bettertext.Say(tostring(dialog)))
end

function paymentFish()
	paidForFish = (GetFishamount("seekerfish") * 3) + (GetFishamount("seaweed") * 1) + (GetFishamount("harpyfish") * 4) + (GetFishamount("lavaKoi") * 6) + (GetFishamount("beeFish") * 5) + (GetFishamount("frostMinnow") * 3)
			   + (GetFishamount("anglerFish") * 12) + (GetFishamount("pleadfish") * 8) + (GetFishamount("cloudfish") * 10) + (GetFishamount("demonicHellfish") * 12) + (GetFishamount("honeyfin") * 9) + (GetFishamount("celesteFish") * 11)
			   + (GetFishamount("fishOfCthulhu") * 28) + (GetFishamount("jellyfish") * 25) + (GetFishamount("momtrout") * 32) + (GetFishamount("theoVoodooFish") * 32) + (GetFishamount("goldfish") * 50) + (GetFishamount("mutantFlinxfin") * 30)
			   + (GetFishamount("rainbowAngelfish") * 100)
	if getFlag("Midas") then
		paidForFish = paidForFish * 2
	end
	return paidForFish
end

function noMoreFishes()
	AddFish("seekerfish", GetFishamount("seekerfish")*-1)
	AddFish("seaweed", GetFishamount("seaweed")*-1)
	AddFish("harpyfish", GetFishamount("harpyfish")*-1)
	AddFish("lavaKoi", GetFishamount("lavaKoi")*-1)
	AddFish("beeFish", GetFishamount("beeFish")*-1)
	AddFish("frostMinnow", GetFishamount("frostMinnow")*-1)
	AddFish("anglerFish", GetFishamount("anglerFish")*-1)
	AddFish("pleadfish", GetFishamount("pleadfish")*-1)
	AddFish("cloudfish", GetFishamount("cloudfish")*-1)
	AddFish("demonicHellfish", GetFishamount("demonicHellfish")*-1)
	AddFish("honeyfin", GetFishamount("honeyfin")*-1)
	AddFish("celesteFish", GetFishamount("celesteFish")*-1)
	AddFish("fishOfCthulhu", GetFishamount("fishOfCthulhu")*-1)
	AddFish("jellyfish", GetFishamount("jellyfish")*-1)
	AddFish("momtrout", GetFishamount("momtrout")*-1)
	AddFish("theoVoodooFish", GetFishamount("theoVoodooFish")*-1)
	AddFish("goldfish", GetFishamount("goldfish")*-1)
	AddFish("mutantFlinxfin", GetFishamount("mutantFlinxfin")*-1)
	AddFish("rainbowAngelfish", GetFishamount("rainbowAngelfish")*-1)
end

function onEnd()
	enableMovement()
	enableRetry()
	berchant.CutsceneModeEnabled = false
end