local luaCutscenesUtils = require("#Celeste.Mod.MaxHelpingHand.Module.LuaCutscenesUtils")
local bettertext = require("#Celeste.Mod.CrossoverCollab.Code.PointsStuff.BetterTextbox")
local save = require("#Celeste.Mod.CrossoverCollab.Code.PointsStuff.PointsModule")
local zoologist = getEntity("DialogNPC", "Celeste.Mod.DoonvHelper.Entities.")
local randomFact = 0
local greeting = 0
local crimsonheart0 = getFlag("crimsonheart00")
local crimsonheart1 = getFlag("crimsonheart01")
local crimsonheart2 = getFlag("crimsonheart02")
local crimsonheart3 = getFlag("crimsonheart03")
local crimsonheart4 = getFlag("crimsonheart04")
local crimsonHeartQuest = getFlag("crimsonHeartQuestDone")

-- Adds a fish with any name, if that fish already exists, adds that many of it
function AddFish(name, amount)
    save.SaveData:AddFish(name, tonumber(amount))
 end
-- Returns how many fish of that type you have (or coins)
function GetFishamount(name)
    return tonumber(save.SaveData:GetFishAmount(name))
end

function bettersay(dialog)
    coroutine.yield(bettertext.Say(tostring(dialog)))
end

function onBegin()
	disableMovement()
	makeUnskippable()
	disableRetry()
	zoologist.CutsceneModeEnabled = true
	math.randomseed(os.time())
	-- The zoologist says hi and you start a dialogue
	playSound("event:/CC/CC_KoseiDiamond/ui_pause")
	if crimsonheart0 and crimsonheart1 and crimsonheart2 and crimsonheart3 and crimsonheart4 and not crimsonHeartQuest then -- gives reward for crimson hearts
		coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_zoologist_dialogue2_5c"))
		playSound("event:/game/general/seed_complete_berry")
		setFlag("crimsonHeartQuestDone")
		if getFlag("Midas") then
			AddFish("terracoins", 100)
			playSound("event:/CC/CC_KoseiDiamond_sounds/terracoin")
			bettersay("Additionally, you also received {#F94A4A}100{#} terracoins!")
		else
			AddFish("terracoins", 50)
			playSound("event:/CC/CC_KoseiDiamond_sounds/terracoin")
			bettersay("Additionally, you also received {#F94A4A}50{#} terracoins!")
		end
		enableMovement()
		enableRetry()
		zoologist.CutsceneModeEnabled = false
		endCutscene()
	end
	if getFlag("collectable_guidecritter") == true and (getFlag("bookQuestDone")) == false then
		coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_zoologist_foundguide"))
		playSound("event:/CC/CC_KoseiDiamond_sounds/terracoin")
		setFlag("bookQuestDone",true)
		if getFlag("Midas") then
			AddFish("terracoins", 200)
			bettersay("You have received {#F94A4A}200{#} terracoins!")
		else
			AddFish("terracoins", 100)
			bettersay("You have received {#F94A4A}100{#} terracoins!")
		end
		bettersay("You have {#F94A4A}"..tostring(GetFishamount("terracoins")).. "{#} terracoins now.")
		enableMovement()
		enableRetry()
		zoologist.CutsceneModeEnabled = false
		endCutscene()
	end
		greeting = math.random(0,2) -- says hi
		if getFlag("cryoGoldenRun") then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_zoologist_golden"))
		else
			if getFlag("PartyCenter") then
				coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_zoologist_party"))
			else
				if greeting == 0 then
					coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_zoologist_greetings"))
				elseif greeting == 1 then
					coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_zoologist_greetingsB"))
				elseif greeting == 2 then
					coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_zoologist_greetingsC"))
				end
			end
		end
		
	coroutine.yield(luaCutscenesUtils.ChoiceWithDifferentFont("ANDYB", "CC_KoseiDiamond_zoologist_dialogue1_1", "CC_KoseiDiamond_zoologist_dialogue1_2", "CC_KoseiDiamond_zoologist_dialogue1_3", "CC_KoseiDiamond_zoologist_dialogue1_4", "CC_KoseiDiamond_zoologist_dialogue1_5"))
	if luaCutscenesUtils.GetChoice() == 1 then -- who are you?
		coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_zoologist_dialogue2_1"))
	elseif luaCutscenesUtils.GetChoice() == 2 then -- random fact
		randomFact = math.random(0,19)
		if randomFact == 0 then
		    coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_zoologist_fact00"))
		elseif randomFact == 1 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_zoologist_fact01"))
		elseif randomFact == 2 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_zoologist_fact02"))
		elseif randomFact == 3 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_zoologist_fact03"))
		elseif randomFact == 4 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_zoologist_fact04"))
		elseif randomFact == 5 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_zoologist_fact05"))
		elseif randomFact == 6 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_zoologist_fact06"))
		elseif randomFact == 7 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_zoologist_fact07"))
		elseif randomFact == 8 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_zoologist_fact08"))
		elseif randomFact == 9 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_zoologist_fact09"))
		elseif randomFact == 10 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_zoologist_fact10"))
		elseif randomFact == 11 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_zoologist_fact11"))
		elseif randomFact == 12 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_zoologist_fact12"))
		elseif randomFact == 13 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_zoologist_fact13"))
		elseif randomFact == 14 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_zoologist_fact14"))
		elseif randomFact == 15 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_zoologist_fact15"))
		elseif randomFact == 16 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_zoologist_fact16"))
		elseif randomFact == 17 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_zoologist_fact17"))
		elseif randomFact == 18 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_zoologist_fact18"))
		elseif randomFact == 19 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_zoologist_fact19"))
		end
	elseif luaCutscenesUtils.GetChoice() == 3 then -- cave
		coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_zoologist_dialogue2_3"))
	elseif luaCutscenesUtils.GetChoice() == 4 then -- info about monsters
		if getFlag("bookQuestDone") == true then
		coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_zoologist_creatures"))
		else
		coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_zoologist_dialogue2_4"))
		end
	elseif luaCutscenesUtils.GetChoice() == 5 then -- why living here
		coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_zoologist_dialogue2_5"))
		if not crimsonheart0 or not crimsonheart1 or not crimsonheart2 or not crimsonheart3 or not crimsonheart4 then
			coroutine.yield(luaCutscenesUtils.SayWithDifferentFont("ANDYB", "CC_KoseiDiamond_zoologist_dialogue2_5b"))
		end
	end
	enableMovement()
	enableRetry()
	zoologist.CutsceneModeEnabled = false
end