local save = require("#Celeste.Mod.CrossoverCollab.Code.PointsStuff.PointsModule")
local monocle = require("#monocle")
local coroutineEntity = monocle.Entity()

-- Adds a flag with the name inside the function
function addflag(flag)
    save.SaveData:AddFlag(flag)
end

function isflagtrue(flag)
    return save.SaveData:IsFlagTrue(flag)
end

-- Removes a flag
function removeflag(flag)
    save.SaveData:RemoveFlag(flag)
end

function onTalk() -- PLACEHOLDER DIALOGUES
	disableMovement()
	disableRetry()
	if not isflagtrue("AlexDateDone") then
		walkTo(1212)
		player.Facing = getEnum("Celeste.Facings", "Right")
		wait(0.05)
		coroutine.yield(getLevel():ZoomTo(vector2(1224/8,112), 1.35, 1))
		say("CC_Lobby_Alex_Date")
		if choice("CC_Lobby_Alex_DateOption1","CC_Lobby_Alex_DateOption2") == 1 then
			say("CC_Lobby_Alex_DateOption1Answer")
			gameChoice = choice("CC_Lobby_Alex_DateGamePrompt_Metroidvania", "CC_Lobby_Alex_DateGamePrompt_Platformer", "CC_Lobby_Alex_DateGamePrompt_RandomGames")
			if gameChoice == 1 then
				say("CC_Lobby_Alex_DateMetroidvania")
			elseif gameChoice == 2 then
				say("CC_Lobby_Alex_DateHardPlatformer")
			else
				say("CC_Lobby_Alex_DateRandomGames")
			end
			say("CC_Lobby_Alex_DatePoints")
			-- idk what else could be between these two dialogues
			say("CC_Lobby_Alex_DateEnd")
			setFlag("blackout",true) -- this flag is for a blackout
			wait(0.5)
			say("CC_Lobby_Alex_DateILY")
			 -- and she goes away
			removeflag("AlexHasCalled")
			getLevel():ResetZoom()
			addflag("AlexDateDone")
			setFlag("AlexHasCalled",false)
			setFlag("AlexIsInCity",false)
			setFlag("blackout",false)
			enableMovement()
			enableRetry()
		else
			say("CC_Lobby_Alex_DateOption2Answer")
		end
	else
		say("CC_Lobby_Alex_Gone")
	end
end

function onEnd(room, wasSkipped)
	getLevel():ResetZoom()
	enableMovement()
	enableRetry()
	if wasSkipped then
		setFlag("blackout",false)
	end
end