local save = require("#Celeste.Mod.CrossoverCollab.Code.PointsStuff.PointsModule")
local bettertext = require("#Celeste.Mod.CrossoverCollab.Code.PointsStuff.BetterTextbox")

function getmoney()
    return save.SaveData:GetMoney()
end

function addmoney(money)
    save.SaveData:AddMoney(tonumber(money))
end

function bettersay(dialog)
    coroutine.yield(bettertext.Say(tostring(dialog)))
end

function addflag(flag)
    save.SaveData:AddFlag(flag)
end

function removeflag(flag)
	save.SaveData:RemoveFlag(flag)
end

function isflagtrue(flag)
    return save.SaveData:IsFlagTrue(flag)
end

function onTalk()
	disableMovement()
	disableRetry()
	walkTo(78)
	teleportTo(78,160)
	setFlag("opening_wardrobe",true)
	setFlag("opened_wardrobe",true)
	wait()
	player.DummyAutoAnimate = false
	player.Facing = getEnum("Celeste.Facings", "Right")
	player.Sprite:Play("closetOpen")
	if not isflagtrue("wardrobeFirstTime") then
		say("CC_Lobby_Wardrobe2")
		playSound("event:/CC/CC_Lobby/CC_money")
		addmoney(10)
		addflag("wardrobeFirstTime")
	else
		say("CC_Lobby_Wardrobe1")
	end
	player.Sprite:Play("closetClose")
	setFlag("opened_wardrobe",false)
	wait(0.64)
end

function onEnd()
	setFlag("opened_wardrobe",false)
	setFlag("opening_wardrobe",false)
	enableMovement()
	enableRetry()
end