local save = require("#Celeste.Mod.CrossoverCollab.Code.PointsStuff.PointsModule")

-- Returns if a flag exists, if it does, returns true, if it doesn't returns false
function isflagtrue(flag)
    return save.SaveData:IsFlagTrue(flag)
end

--adds the value [money] to their total
function addmoney(money)
    save.SaveData:AddMoney(tonumber(money))
end

--returns a bool, checks if the value [points] is greater than their total points, example, they have 400 points, if value = 390, it returns true, if value is 410 returns false
function checkpoints(points)
    return save.SaveData:CheckPoints(tonumber(points));
end

--returns an int that equals their points
function getpoints()
    return save.SaveData:GetPoints();
end

-- Adds a flag with the name inside the function
function addflag(flag)
    save.SaveData:AddFlag(flag)
end

function onBegin()
	wait()
	
	-- Time of the day
	for i=0,23 do
		if i == os.date("*t").hour then
			setFlag("currentHour"..i,true)
		else
			setFlag("currentHour"..i,false)
		end
	end
	if os.date("*t").hour >= 7 and os.date("*t").hour <= 21 then
		setFlag("isNight",false)
		setFlag("isDay",true)
		setDarkness(0.1)
		setBloomStrength(0.6)
	else
		setFlag("isNight",true)
		setFlag("isDay",false)
		setDarkness(0.2)
		setBloomStrength(0.8)
	end
	
	local theme = 1
	for i=1,4,1 do -- shopTheme
		if isflagtrue("furniture_wallpapers_theme"..tostring(theme)) then
			setFlag("shopTheme"..tostring(theme),true)
		else
			setFlag("shopTheme"..tostring(theme),false)
		end
		theme = theme + 1
	end
	theme = 1
	for i=1,3,1 do -- furniture_bed_theme
		if isflagtrue("furniture_bedsheets_theme"..tostring(theme)) then
			setFlag("furniture_bed_theme"..tostring(theme),true)
		else
			setFlag("furniture_bed_theme"..tostring(theme),false)
		end
		theme = theme + 1
	end
	theme = 1
	for i=1,3,1 do -- furniture_courtains_theme
		if isflagtrue("furniture_courtains_theme"..tostring(theme)) then
			setFlag("furniture_courtains_theme"..tostring(theme),true)
		else
			setFlag("furniture_courtains_theme"..tostring(theme),false)
		end
		theme = theme + 1
	end
	
	setFlag("furniture_nail",isflagtrue("furniture_nail"))
	setFlag("furniture_mysteryegg",isflagtrue("furniture_mysteryegg"))
	setFlag("furniture_bulletkin",isflagtrue("furniture_bulletkin"))
	setFlag("furniture_slugcat",isflagtrue("furniture_slugcat"))
	setFlag("furniture_medamaude",isflagtrue("furniture_medamaude"))
	setFlag("furniture_manipulator",isflagtrue("furniture_manipulator"))
	setFlag("furniture_lute",isflagtrue("furniture_lute"))

	setFlag("AlexHasCalled",isflagtrue("AlexHasCalled"))
	
	-- UNIQUE EVENTS
	
	if (not isflagtrue("FirstComoxPayment") and getpoints() >=450) then -- gives 60G when player has >=450 points
		makeUnskippable()
		disableMovement()
		disableRetry()
		postcard("CC_Lobby_Room_Postcard1","event:/game/03_resort/memo_in","event:/game/03_resort/memo_out")
		addflag("FirstComoxPayment")
		addmoney(60)
		playSound("event:/CC/CC_Lobby/CC_money")
		enableMovement()
	end
	if (not isflagtrue("SecondComoxPayment") and getpoints() >=900) then
		makeUnskippable()
		disableMovement()
		disableRetry()
		postcard("CC_Lobby_Room_Postcard2","event:/game/03_resort/memo_in","event:/game/03_resort/memo_out")
		addflag("SecondComoxPayment")
		addmoney(70)
		playSound("event:/CC/CC_Lobby/CC_money")
		enableMovement()
	end
	
	if (not isflagtrue("AlexHasCalled") and getpoints() >=350 and not isflagtrue("AlexDateDone")) then -- Alex calls
		makeUnskippable()
		disableMovement()
		disableRetry()
		setMusicLayer(1,0)
		wait(0.5)
		playSound("event:/CC/CC_Lobby/PhoneRing")
		wait(4.25)
		say("CC_Lobby_Alex_Calling")
		addflag("AlexHasCalled")
		setFlag("AlexHasCalled",true)
		setFlag("AlexIsInCity",true)
		setMusicLayer(1,1)
		enableMovement()
	end
	enableRetry()
end