sampler2D TextureSampler : register(s0);


uniform float2 pscale;
uniform float time;

float4 valAt(float2 pos, float offsetx, float offsety){
    return tex2D(TextureSampler,pos+float2(offsetx,offsety)*pscale);
}


float4 main(float4 color : COLOR0, float2 pos : TEXCOORD0) : SV_Target {
  return valAt(pos, 0, 3 * sin(pos.y*16 + time % 6.283185307));
}

technique BasicTech {
    pass Pass0 {
        PixelShader = compile ps_3_0 main();
    }
}