local celeste = require("#Celeste.Celeste")
local vector2 = require("#microsoft.xna.framework.vector2")
local exCameraHelper = require("#Celeste.Mod.ExCameraDynamics.Code.Module.ExCameraInterop")

function onBegin()
    
    disableMovement()

    setDarkness(0.3)
    setBloomStrength(0.4)

    local level = getLevel()
    coroutine.yield(exCameraHelper.Level_ZoomToFocus(level, vector2(656, 386), 1, 0.01))

    player.Facing = getEnum("Celeste.Facings", "Right")

    wait(1)

    player.ForceCameraUpdate = true
    walkTo (740, false, 0.8, false)
    playMusic("event:/WHE/WHE_dusk")
    wait(0.5)
    player.DummyAutoAnimate = false
    player.Sprite:Play("lookUp")
    wait(3)
    say("WHE_NaCline_C_03")
    player.DummyAutoAnimate = true
    wait(2)
    say("WHE_NaCline_C_04")
    player.ForceCameraUpdate = false
    
    enableMovement()
    endCutscene ()

end

function onEnd(level, wasSkipped)
	if wasSkipped then
		
        playMusic("event:/WHE/WHE_dusk")
        player.ForceCameraUpdate = false
        endCutscene ()
		enableMovement()
        
	end
end