local vector2 = require("#microsoft.xna.framework.vector2")
local exCameraHelper = require("#Celeste.Mod.ExCameraDynamics.Code.Module.ExCameraInterop")
local cameraFocus = require("#Celeste.Mod.ExCameraDynamics.Code.Entities.CameraFocus")
local cameraZoomHooks = require("#Celeste.Mod.ExCameraDynamics.Code.Hooks.CameraZoomHooks")

function onBegin()

    disableMovement()
    disablePause ()

    
    player.ForceCameraUpdate = true
    --local level = getLevel()
    --coroutine.yield(exCameraHelper.Level_ZoomToFocus(level, vector2(2792, 4224), 1, 0.001))
    setCameraOffset (0, -6)
    setDarkness(0.2)
    setBloomStrength(0.5)

    player.Facing = getEnum("Celeste.Facings", "Left")
    player.DummyAutoAnimate = false
    player.Sprite:Play("lookUp")

    setFlag("LuckyHelper_DisableCameraUpdateOnTeleportFlag",false)
    setFlag("LuckyHelper_DisablePlayerCameraUpdate",false)

    local cameray = -6
    while (true) do
        wait(0.05)
        cameray = cameray + 0.1
        setCameraOffset (0, cameray)

        if cameray > 0 then
            break
        end

    end

    player.ForceCameraUpdate = false

    wait(4)
    
    setFlag("LuckyHelper_DisableCameraUpdateOnTeleportFlag",true)
    setFlag("LuckyHelper_DisablePlayerCameraUpdate",true)
    
    local level = getLevel()
    cameraZoomHooks.ForceCameraTo(level, cameraFocus.FromCenter(vector2(3240, 4324), 2))
    teleportTo(3240, 4354, "feel_07")

    enableMovement()
    enablePause ()
    endCutscene ()
	

end