local vector2 = require("#microsoft.xna.framework.vector2")
local exCameraHelper = require("#Celeste.Mod.ExCameraDynamics.Code.Module.ExCameraInterop")

function onBegin()

    disableMovement()
    makeUnskippable ()

    local level = getLevel()
    coroutine.yield(exCameraHelper.Level_ZoomToFocus(level, vector2(656, 3060), 1, 0.01))

    setFlag("LuckyHelper_DisableCameraUpdateOnTeleportFlag",false)
    setFlag("LuckyHelper_DisablePlayerCameraUpdate",false)

    wait(2)
    player.Facing = getEnum("Celeste.Facings", "Right")

    local darkness = getDarkness ()
    while (true) do
        wait(0.01)
        darkness = darkness - 0.02
        setDarkness (darkness)
        if darkness < 0.02 then
            break
        end
    end

    wait(1)
    playSound("event:/WHE/WHE_keyboard1")

    wait(4)
    walkTo (668, walkBackwards==false, speedMultiplier==1.2, keepWalkingIntoWalls==false)

    local level = getLevel()
    coroutine.yield(exCameraHelper.Level_ZoomToFocus(level, vector2(676, 3060), 2, 1.5))
    --coroutine.yield(level:ZoomTo(vector2(180, 90), 2, 1.5))

    wait(0.5)
    player.DummyAutoAnimate = false
    player.Sprite:Play("lookUp")
    wait(0.5)
    say("WHE_NaCline_F_01")
    wait(0.5)
    player.DummyAutoAnimate = false
    say("WHE_NaCline_F_02")

    playMusic("event:/WHE/WHE_sunset1")

    local level = getLevel()
    coroutine.yield(exCameraHelper.Level_ZoomToFocus(level, vector2(656, 3060), 1, 1.5))

    runTo (766, false)

    local darkness = getDarkness ()
    while (true) do
        wait(0.01)
        darkness = darkness + 0.1
        setDarkness (darkness)
        if darkness > 0.9 then
            break
        end
    end

    wait(0.3)
    teleportTo(1032, 3096, "sunset_02")

    enableMovement()
    endCutscene ()

end