local vector2 = require("#microsoft.xna.framework.vector2")
local exCameraHelper = require("#Celeste.Mod.ExCameraDynamics.Code.Module.ExCameraInterop")

function onBegin()

    disableMovement()
    makeUnskippable ()

    local darkness = 1
    setDarkness (darkness)
    while (true) do
        wait(0.01)
        darkness = darkness - 0.1
        setDarkness (darkness)
        if darkness < 0.1 then
            break
        end
    end

    wait(0.3)
    runTo (1660, true)

    player.DummyAutoAnimate = false
    playSound("event:/WHE/WHE_fall")
    player.Sprite:Play("fallPose")
    wait(1)
    player.DummyAutoAnimate = true

    walkTo (1680, walkBackwards==false, speedMultiplier==1.3, keepWalkingIntoWalls==false)

    local level = getLevel()
    coroutine.yield(exCameraHelper.Level_ZoomToFocus(level, vector2(1696, 3060), 2, 1))
    --coroutine.yield(level:ZoomTo(vector2(160, 90), 2, 1))

    say("WHE_NaCline_F_04")
    player.DummyAutoAnimate = false
    player.Sprite:Play("faint")
    wait(2)

    local darkness = getDarkness ()
    while (true) do
        wait(0.01)
        darkness = darkness + 0.1
        setDarkness (darkness)
        if darkness > 0.9 then
            break
        end
    end

    player.DummyAutoAnimate = true

    wait(0.5)
    teleportTo(2312, 2487, "fade_02")

    enableMovement()
    endCutscene ()

end