local drawableSprite = require("structs.drawable_sprite")
local drawableLine = require("structs.drawable_line")
local utils = require("utils")
local atlases = require("atlases")

local boostar = {}

boostar.name = "AdamsAddons/Boostar"
boostar.depth = -8500
boostar.nodeVisibility = "always"
boostar.nodeLineRenderType = false
boostar.nodeLimits = {1, -1}
boostar.placements = {
    {
        name = "boostar",
        data = {
            sprites = "Anzen/AdamsAddons/",
            particleColor = "3898ff",
            particleColorSlow = "13467a",
            lineColor = "ffffff",
            delayed = false,
            cycle = false
        }
    },
    {
        name = "boostar_slow",
        data = {
            sprites = "Anzen/AdamsAddons/",
            particleColor = "3898ff",
            particleColorSlow = "13467a",
            lineColor = "ffffff",
            delayed = true,
            cycle = false
        }
    }
}

boostar.fieldOrder = {"x", "y", "delayed", "cycle", "sprites", "particleColor", "particleColorSlow", "lineColor"}

boostar.fieldInformation = {
    particleColor = {
        fieldType = "color",
        allowEmpty = true
    },
    particleColorSlow = {
        fieldType = "color",
        allowEmpty = true
    },
    lineColor = {
        fieldType = "color",
        allowEmpty = true
    }
}

function boostar.sprite(room, entity, viewport)
    local prefix = "objects/boostar/"
    if entity.delayed then
        prefix = "objects/boostarSlow/"
    end

    local boostarPath = prefix .. "Anzen/AdamsAddons/booster00"
    local outlinePath = prefix .. "Anzen/AdamsAddons/outline"
    local starPath = prefix .. "Anzen/AdamsAddons/star"
    local miniPath = prefix .. "Anzen/AdamsAddons/booster_mini"

    if atlases.gameplay[prefix .. entity.sprites .. "booster00"] then
        boostarPath = prefix .. entity.sprites .. "booster00"
    end
    if atlases.gameplay[entity.sprites .. "outline"] then
        starPath = prefix .. entity.sprites .. "outline"
    end
    if atlases.gameplay[entity.sprites .. "star"] then
        starPath = prefix .. entity.sprites .. "star"
    end
    if atlases.gameplay[entity.sprites .. "booster_mini"] then
        miniPath = prefix .. entity.sprites .. "booster_mini"
    end

    local sprites = {}

    if entity.nodes and #entity.nodes > 0 then
        local nodes = entity.nodes
        local nx, ny = 0, 0

        local mx, my = entity.x, entity.y
        for i, node in ipairs(nodes) do
            nx, ny = node.x, node.y

            table.insert(sprites, drawableLine.fromPoints({mx, my, nx, ny}, entity.lineColor))
            mx, my = nx, ny
        end

        if entity.cycle then
            table.insert(sprites, drawableLine.fromPoints({mx, my, entity.x, entity.y}, entity.lineColor))
        end

        local mx, my = entity.x, entity.y
        for i, node in ipairs(nodes) do
            nx, ny = node.x, node.y

            if i == 1 then
                table.insert(sprites, drawableSprite.fromTexture(miniPath, {x = nx, y = ny}))
            else
                table.insert(sprites, drawableSprite.fromTexture(starPath, {x = nx, y = ny}))
            end
            table.insert(sprites, drawableSprite.fromTexture(outlinePath, {x = nx, y = ny}))
            mx, my = nx, ny
        end

    end

    table.insert(sprites, drawableSprite.fromTexture(boostarPath, entity))

    return sprites
end

function boostar.nodeSprite(room, entity, node, nodeIndex, viewport)
end

function boostar.selection(room, entity)
    local mainRectangle = utils.rectangle(entity.x - 10, entity.y - 10, 20, 20)

    local nodeRectangles = {}

    if entity.nodes and #entity.nodes > 0 then
        local nodes = entity.nodes or {x = entity.x, y = entity.y}
        
        for i, node in ipairs(nodes) do
            local nx, ny = node.x, node.y

            table.insert(nodeRectangles, utils.rectangle(nx - 10, ny - 10, 20, 20))
        end
    end

    return mainRectangle, nodeRectangles
end

return boostar