local spikeHelper = require("helpers.spikes")
local atlases = require("atlases")

local spikeUp = spikeHelper.createEntityHandler("AdamsAddons/CyclingSpikesUp", "up")
local spikeDown = spikeHelper.createEntityHandler("AdamsAddons/CyclingSpikesDown", "down")
local spikeLeft = spikeHelper.createEntityHandler("AdamsAddons/CyclingSpikesLeft", "left")
local spikeRight = spikeHelper.createEntityHandler("AdamsAddons/CyclingSpikesRight", "right")

spikeUp.direction = "up"
spikeDown.direction = "down"
spikeLeft.direction = "left"
spikeRight.direction = "right"

local spikes = {
    spikeUp,
    spikeDown,
    spikeLeft,
    spikeRight
}

local function getSpikePlacements(direction)
    local placements = {}
    local horizontal = direction == "left" or direction == "right"
    local lengthKey = horizontal and "height" or "width"

    local placement = {
        name = "spike",
        data = {
            type = "Anzen/AdamsAddons/wave",
            offset = 0,
            randomize = true
        }
    }

    placement.data[lengthKey] = 8

    return { placement }
end

local function addZero(number)
    if(number<10) then
        return (0 .. number)
    else
        return number
    end
end

-- Lönn spike helper copypaste begin
local drawableSprite = require("structs.drawable_sprite")

local spikeTexture = "danger/spikes/%s_%s%s"

local spikeOffsets = {
    up = {0, 1},
    down = {0, -1},
    right = {-1, 0},
    left = {1, 0}
}

local spikeJustifications = {
    up = {0.0, 1.0},
    down = {0.0, 0.0},
    right = {0.0, 0.0},
    left = {1.0, 0.0}
}

local function getDirectionJustification(direction)
    return unpack(spikeJustifications[direction] or {0, 0})
end

local function getDirectionOffset(direction)
    return unpack(spikeOffsets[direction] or {0, 0})
end

local function getSpikeSpritesFromTexture(entity, direction, variant, limit)
    step = 8

    local horizontal = direction == "left" or direction == "right"
    local justificationX, justificationY = getDirectionJustification(direction)
    local offsetX, offsetY = getDirectionOffset(direction)
    local rotation = 0
    local length = horizontal and (entity.height or step) or (entity.width or step)
    local positionOffsetKey = horizontal and "y" or "x"

    local position = {
        x = entity.x,
        y = entity.y
    }

    local sprites = {}

    for i = 0, length - 1, step do
        -- Tentacles overlap instead of "overflowing"
        if i == length - step / 2 then
            position[positionOffsetKey] -= step / 2
        end

        local sprite = drawableSprite.fromTexture(string.format(spikeTexture, variant, direction, addZero((entity.offset + (i/8)) % limit)), position)

        sprite.depth = spikeDepth
        sprite.rotation = rotation
        sprite:setJustification(justificationX, justificationY)
        sprite:addPosition(offsetX, offsetY)

        table.insert(sprites, sprite)

        position[positionOffsetKey] += step
    end

    return sprites
end

local function getNormalSpikeSprites(entity, direction)
    local variant = entity.type or "Anzen/AdamsAddons/wave"
    local limit = 0
    local texture = ""

    repeat
        limit += 1
        texture = string.format(spikeTexture, variant, direction, addZero(limit))
    until not atlases.gameplay[texture]

    return getSpikeSpritesFromTexture(entity, direction, variant, limit)
end

-- Lönn spike helper copypaste end

for _, spike in ipairs(spikes) do
    spike.placements = getSpikePlacements(spike.direction)

    local direction = spike.direction
    function spike.sprite(room, entity)
        return getNormalSpikeSprites(entity, direction)
    end

    spike.fieldInformation = {
        type = {
            options = {
                {"wave","Anzen/AdamsAddons/wave"},
                {"thorn","Anzen/AdamsAddons/thorn"},
                {"crystal","Anzen/AdamsAddons/crystal"},
                {"lego","Anzen/AdamsAddons/lego"},
                {"default","default"},
                {"outline","outline"},
                {"cliffside","cliffside"},
                {"reflection","reflection"}
            }
        },
        offset = {
            fieldType = "integer"
        },
        randomize = {
            fieldType = "boolean"
        }
    }
end

spikeUp.flip = function(room, entity, direction)
    if direction then
        entity.offset = entity.offset + 1
    else
        entity._name = "AdamsAddons/CyclingSpikesDown"
    end
    return true
end

spikeDown.flip = function(room, entity, direction)
    if direction then
        entity.offset = entity.offset + 1
    else
        entity._name = "AdamsAddons/CyclingSpikesUp"
    end
    return true
end

spikeLeft.flip = function(room, entity, direction)
    if direction then
        entity._name = "AdamsAddons/CyclingSpikesRight"
    else
        entity.offset = entity.offset + 1
    end
    return true
end

spikeRight.flip = function(room, entity, direction)
    if direction then
        entity._name = "AdamsAddons/CyclingSpikesLeft"
    else
        entity.offset = entity.offset + 1
    end
    return true
end

spikeUp.rotate = function(room, entity, direction)
    if direction > 0 then
        entity._name = "AdamsAddons/CyclingSpikesRight"
    else
        entity._name = "AdamsAddons/CyclingSpikesLeft"
    end

    entity.width, entity.height = entity.height, entity.width
    return true
end

spikeDown.rotate = function(room, entity, direction)
    if direction > 0 then
        entity._name = "AdamsAddons/CyclingSpikesLeft"
    else
        entity._name = "AdamsAddons/CyclingSpikesRight"
    end

    entity.width, entity.height = entity.height, entity.width
    return true
end

spikeLeft.rotate = function(room, entity, direction)
    if direction > 0 then
        entity._name = "AdamsAddons/CyclingSpikesUp"
    else
        entity._name = "AdamsAddons/CyclingSpikesDown"
    end

    entity.width, entity.height = entity.height, entity.width
    return true
end

spikeRight.rotate = function(room, entity, direction)
    if direction > 0 then
        entity._name = "AdamsAddons/CyclingSpikesDown"
    else
        entity._name = "AdamsAddons/CyclingSpikesUp"
    end

    entity.width, entity.height = entity.height, entity.width
    return true
end

return spikes