local drawableSprite = require("structs.drawable_sprite")
local drawableLine = require("structs.drawable_line")
local drawableRectangle = require("structs.drawable_rectangle")
local utils = require("utils")

local puzzleSlot = {}

puzzleSlot.name = "AdamsAddons/LonnPuzzleSlot"
puzzleSlot.depth = -100
puzzleSlot.canResize = {true, true}
puzzleSlot.nodeVisibility = "always"
puzzleSlot.nodeLimits = {1, 1}
puzzleSlot.placements = {
    name = "slot",
    alternativeName = "slot_alt",
    data = {
        width = 8,
        height = 8,
        flag = ""
    }
}

function puzzleSlot.sprite(room, entity, viewport)
    local node = entity.nodes[1]
    local mainRectangle = utils.rectangle(entity.x,entity.y,entity.width,entity.height)
    local nodeRectangle = utils.rectangle(node.x,node.y,entity.width,entity.height)

    return {
        drawableRectangle.fromRectangle("bordered", nodeRectangle, {39 / 255, 169 / 255, 224 / 255, 0.25}, {39 / 255, 169 / 255, 224 / 255, 1}),
        drawableRectangle.fromRectangle("bordered", mainRectangle, {226 / 255, 72 / 255, 150 / 255, 0.25}, {226 / 255, 72 / 255, 150 / 255, 1}),
        drawableSprite.fromTexture("objects/lonnPuzzleSlot/Anzen/AdamsAddons/puzzle_slot", {x = node.x + entity.width / 2, y = node.y + entity.height / 2}),
        drawableLine.fromPoints({entity.x + entity.width / 2, entity.y + entity.height / 2, node.x + entity.width / 2, node.y + entity.height / 2}, {1,1,1,0.25}),
        drawableSprite.fromTexture("objects/lonnPuzzleSlot/Anzen/AdamsAddons/puzzle_piece", {x = entity.x + entity.width / 2, y = entity.y + entity.height / 2})
    }
end

function puzzleSlot.nodeSprite(room, entity, node, nodeIndex, viewport)
end

function puzzleSlot.selection(room, entity)
    local node = entity.nodes[1]

    return utils.rectangle(entity.x,entity.y,entity.width,entity.height), {utils.rectangle(node.x,node.y,entity.width,entity.height)}
end

return puzzleSlot