local drawableSprite = require("structs.drawable_sprite")
local utils = require("utils")
local atlases = require("atlases")

local shrine = {}

shrine.name = "AdamsAddons/LonnShrine"
shrine.depth = 8000
shrine.placements = {
    name = "shrine",
    alternativeName = "shrine_alt",
    data = {
        sprites = "",
        overlayAlpha = 0.5,
        flag = "adamsaddons_shrine_active"
    }
}

shrine.fieldInformation = {
    overlayAlpha = {
        fieldType = "number",
        minimumValue = 0,
        maximumValue = 1
    }
}

function shrine.sprite(room, entity, viewport)
    local shrinePath = "objects/lonnShrine/Anzen/AdamsAddons/shrine"
    if sprites ~= "" and atlases.gameplay["objects/lonnShrine/" .. entity.sprites .. "shrine"] then
        shrinePath = "objects/lonnShrine/" .. entity.sprites .. "shrine"
    end

    local shrineSprite = drawableSprite.fromTexture(shrinePath, entity)
    shrineSprite:addPosition(0,4)

    local cursorPath = "objects/lonnShrine/Anzen/AdamsAddons/cursor"
    if sprites ~= "" and atlases.gameplay["objects/lonnShrine/" .. entity.sprites .. "cursor"] then
        cursorPath = "objects/lonnShrine/" .. entity.sprites .. "cursor"
    end

    local cursorSprite = drawableSprite.fromTexture(cursorPath, entity)
    cursorSprite:addPosition(0,-7)

    local outlineRight = drawableSprite.fromTexture(cursorPath, {x=entity.x+1,y=entity.y-7,color={0,0,0,1}})
    local outlineLeft = drawableSprite.fromTexture(cursorPath, {x=entity.x-1,y=entity.y-7,color={0,0,0,1}})
    local outlineUp = drawableSprite.fromTexture(cursorPath, {x=entity.x,y=entity.y-6,color={0,0,0,1}})
    local outlineDown = drawableSprite.fromTexture(cursorPath, {x=entity.x,y=entity.y-8,color={0,0,0,1}})

    return {shrineSprite,outlineRight,outlineLeft,outlineUp,outlineDown,cursorSprite}
end

function shrine.selection(room, entity)
    return utils.rectangle(entity.x - 16, entity.y - 16, 32, 32)
end

return shrine