local drawableSpriteStruct = require("structs.drawable_sprite")
local drawing = require("utils.drawing")
local utils = require("utils")
local enums = require("consts.celeste_enums")

local textures = {"wood", "dream", "temple", "templeB", "cliffside", "reflection", "core", "moon"}

local function getTexture(entity)
    return entity.texture and entity.texture ~= "default" and entity.texture or "wood"
end

local jumpthru = {}

jumpthru.name = "AdamsAddons/SmallJumpThru"
jumpthru.depth = -9000
jumpthru.canResize = {false, false}
jumpthru.fieldInformation = {
    texture = {
        options = textures
    },
    surfaceIndex = {
        options = enums.tileset_sound_ids,
        fieldType = "integer"
    },
    width = {
        fieldType = "integer",
        minimumValue = 8,
        maximumValue = 8
    }
}
jumpthru.placements = {
    name = "jumpthru",
    data = {
        width = 8,
        texture = "wood",
        surfaceIndex = -1
    }
}

function jumpthru.sprite(room, entity)
    local textureRaw = getTexture(entity)
    local texture = "objects/smallJumpthru/" .. textureRaw

    local x, y = entity.x or 0, entity.y or 0

    local startX, startY = math.floor(x / 8) + 1, math.floor(y / 8) + 1

    local quadX = room.tilesFg.matrix:get(startX + 1, startY, "0") ~= "0" and 8 or 0
    local quadY = room.tilesFg.matrix:get(startX - 1, startY, "0") ~= "0" and 8 or 0

    local sprite = drawableSpriteStruct.fromTexture(texture, entity)

    sprite:setJustification(0, 0)
    sprite:useRelativeQuad(quadX, quadY, 8, 8)

    return sprite
end

function jumpthru.selection(room, entity)
    return utils.rectangle(entity.x, entity.y, 8, 8)
end

return jumpthru