#define DECLARE_TEXTURE(Name, index) \
    texture Name: register(t##index); \
    sampler Name##Sampler: register(s##index)

#define SAMPLE_TEXTURE(Name, texCoord) tex2D(Name##Sampler, texCoord)

uniform float Time; // level.TimeActive
uniform float2 CamPos; // level.Camera.Position
uniform float2 Dimensions; // new Vector2(320, 180)

uniform float4x4 TransformMatrix;
uniform float4x4 ViewMatrix;

DECLARE_TEXTURE(text, 0);

float4 SpritePixelShader(float2 uv : TEXCOORD0) : COLOR0
{
    float2 worldPos = (uv * Dimensions) + CamPos;

    float k = 0.3;

    float2 offsetUV = uv - 0.5;
    float r = length(offsetUV);
    float2 dir = (r > 0.0) ? (offsetUV / r) : float2(0.0, 0.0);
    float rPrime = r * (1.0 + k * r * r);

    float2 newUV = dir * rPrime;
    newUV += 0.5;
    float3 color = float3(0,0,0);
    if (newUV.x > 0 && newUV.x < 1 && newUV.y > 0 && newUV.y < 1)
    {
        color = SAMPLE_TEXTURE(text, newUV).rgb;
        color += (((newUV.y * Dimensions.y) + (Time * 10)) % 3) / 100;
        if ((newUV.y + (Time * 100)) % 2 < 0.8){
            color /= 1.05;
        } else {
            color += ((newUV.y + (Time * 100) - 0.8) % 2) / 120;
        }
    }

    return float4(color,SAMPLE_TEXTURE(text, uv).a);
}

void SpriteVertexShader(inout float4 color    : COLOR0,
                        inout float2 texCoord : TEXCOORD0,
                        inout float4 position : SV_Position)
{
    position = mul(position, ViewMatrix);
    position = mul(position, TransformMatrix);
}

technique Shader
{
    pass pass0
    {
        VertexShader = compile vs_3_0 SpriteVertexShader();
        PixelShader = compile ps_3_0 SpritePixelShader();
    }
}