#define DECLARE_TEXTURE(Name, index) \
    texture Name: register(t##index); \
    sampler Name##Sampler: register(s##index)

#define SAMPLE_TEXTURE(Name, texCoord) tex2D(Name##Sampler, texCoord)

uniform float Time; // level.TimeActive
uniform float2 CamPos; // level.Camera.Position
uniform float2 Dimensions; // new Vector2(320, 180)

uniform float4x4 TransformMatrix;
uniform float4x4 ViewMatrix;

DECLARE_TEXTURE(text, 0);

float4 SpritePixelShader(float2 uv : TEXCOORD0) : COLOR0
{
    float2 worldPos = (uv * Dimensions) + CamPos;
    float3 color = SAMPLE_TEXTURE(text, uv).rgb;

    float dist = 1;
    float2 pos = uv;
    float3 sampled = color;
    float strength = 1;
    for (int i = 0; i < 80; i++){
        pos = float2(uv.x + (0.0006 * dist),uv.y - (0.003 * dist));
        sampled = SAMPLE_TEXTURE(text, pos).rgb;
        if (sampled.r + sampled.g + sampled.b > 2.3 && pos.y > 0){
            color += 0.01 * strength;
        }
        dist += 1;
        strength /= 1.04;
    }

    return float4(color,SAMPLE_TEXTURE(text, uv).a);
}

void SpriteVertexShader(inout float4 color    : COLOR0,
                        inout float2 texCoord : TEXCOORD0,
                        inout float4 position : SV_Position)
{
    position = mul(position, ViewMatrix);
    position = mul(position, TransformMatrix);
}

technique Shader
{
    pass pass0
    {
        VertexShader = compile vs_3_0 SpriteVertexShader();
        PixelShader = compile ps_3_0 SpritePixelShader();
    }
}