#define DECLARE_TEXTURE(Name, index) \
    texture Name: register(t##index); \
    sampler Name##Sampler: register(s##index)

#define SAMPLE_TEXTURE(Name, texCoord) tex2D(Name##Sampler, texCoord)

uniform float Time; // level.TimeActive
uniform float2 CamPos; // level.Camera.Position
uniform float2 Dimensions; // new Vector2(320, 180)

uniform float4x4 TransformMatrix;
uniform float4x4 ViewMatrix;

DECLARE_TEXTURE(text, 0);

float4 SpritePixelShader(float2 uv : TEXCOORD0) : COLOR0
{
    float2 worldPos = (uv * Dimensions) + CamPos;
    float4 color = SAMPLE_TEXTURE(text, uv);

    float brightness = (color.r + color.g + color.b) / 3;
    float4 sampled = color;
    float samplebrightness = brightness;

    float dir = 0.0;
    for (int i = 0; i < 8; i++){
        sampled = SAMPLE_TEXTURE(text, float2(uv.x + (sin(dir) * 0.004),uv.y + (cos(dir) * 0.007)));
        samplebrightness = (sampled.r + sampled.g + sampled.b) / 3;

        if (samplebrightness + 0.01 < brightness){
            color += 0.003;
        }
        if (samplebrightness - 0.01 > brightness){
            color -= 0.003;
        }

        dir += 360 / 8;
    }

    return color;
}

void SpriteVertexShader(inout float4 color    : COLOR0,
                        inout float2 texCoord : TEXCOORD0,
                        inout float4 position : SV_Position)
{
    position = mul(position, ViewMatrix);
    position = mul(position, TransformMatrix);
}

technique Shader
{
    pass pass0
    {
        VertexShader = compile vs_3_0 SpriteVertexShader();
        PixelShader = compile ps_3_0 SpritePixelShader();
    }
}