#define DECLARE_TEXTURE(Name, index) \
    texture Name: register(t##index); \
    sampler Name##Sampler: register(s##index)

#define SAMPLE_TEXTURE(Name, texCoord) tex2D(Name##Sampler, texCoord)

uniform float Time; // level.TimeActive
uniform float2 CamPos; // level.Camera.Position
uniform float2 Dimensions; // new Vector2(320, 180)

uniform float4x4 TransformMatrix;
uniform float4x4 ViewMatrix;

DECLARE_TEXTURE(text, 0);

float rand(float2 co) {
    return frac(sin(dot(co.xy, float2(12.9898, 78.233))) * 43758.5453);
}

float4 SpritePixelShader(float2 uv : TEXCOORD0) : COLOR0
{
    float2 worldPos = (uv * Dimensions) + CamPos;
    float3 color = SAMPLE_TEXTURE(text, uv).rgb;

    if (rand(float2(worldPos.x,worldPos.x)) > 0.93){
        float dist = 1;
        float strength = 1 * (sin(Time + (worldPos.x * 2000)) / 2 + 0.5);
        float3 sampled = color;
        float sample_brightness = 0;

        for (int i = 0; i < 32; i++){
            sampled = SAMPLE_TEXTURE(text, float2(uv.x,uv.y + ((uv.y / Dimensions.y) * dist))).rgb;
            sample_brightness = (sampled.r + sampled.g + sampled.b) / 3;
            if (sample_brightness > 0.8){
                color = lerp(color,float3(1.0,1.0,1.0),strength * 0.02);        
            }
            sampled = SAMPLE_TEXTURE(text, float2(uv.x,uv.y - ((uv.y / Dimensions.y) * dist))).rgb;
            sample_brightness = (sampled.r + sampled.g + sampled.b) / 3;
            if (sample_brightness > 0.8){
                color = lerp(color,float3(1.0,1.0,1.0),strength * 0.02);        
            }
            dist += 1;
            strength /= 1.1;
        }
    }

    return float4(color,SAMPLE_TEXTURE(text, uv).a);
}

void SpriteVertexShader(inout float4 color    : COLOR0,
                        inout float2 texCoord : TEXCOORD0,
                        inout float4 position : SV_Position)
{
    position = mul(position, ViewMatrix);
    position = mul(position, TransformMatrix);
}

technique Shader
{
    pass pass0
    {
        VertexShader = compile vs_3_0 SpriteVertexShader();
        PixelShader = compile ps_3_0 SpritePixelShader();
    }
}