#define DECLARE_TEXTURE(Name, index) \
    texture Name: register(t##index); \
    sampler Name##Sampler: register(s##index)

#define SAMPLE_TEXTURE(Name, texCoord) tex2D(Name##Sampler, texCoord)

uniform float Time; // level.TimeActive
uniform float2 CamPos; // level.Camera.Position
uniform float2 Dimensions; // new Vector2(320, 180)

uniform float4x4 TransformMatrix;
uniform float4x4 ViewMatrix;

DECLARE_TEXTURE(text, 0);

float fracDot(float2 a, float2 b){
    return frac(sin(dot(a, b)) * 43758.5453123);
}

float rand(float2 co) {
    return frac(sin(dot(co.xy, float2(12.9898, 78.233))) * 43758.5453);
}

float noise(float2 p){
    return fracDot(p, float2(127.1, 311.7));
}

float smoothNoise(float2 p){
    float2 i = floor(p);
    float2 f = frac(p);
    float2 u = f * f * (3.0 - 2.0 * f);

    float n00 = noise(i);
    float n10 = noise(i + float2(1.0, 0.0));
    float n01 = noise(i + float2(0.0, 1.0));
    float n11 = noise(i + float2(1.0, 1.0));

    float x1 = lerp(n00, n10, u.x);
    float x2 = lerp(n01, n11, u.x);
    return lerp(x1, x2, u.y);
}

float fbm(float2 p){
    float total = 0.0;
    float amplitude = 0.5;
    float frequency = 1.0;

    [unroll]
    for (int i = 0; i < 1; i++)
    {
        total += amplitude * smoothNoise(p * frequency);
        frequency *= 2.0;
        amplitude *= 0.5;
    }

    return total;
}

float4 SpritePixelShader(float2 uv : TEXCOORD0) : COLOR0
{
    float2 worldPos = (uv * Dimensions) + CamPos;
    float2 worldPosA = (uv * Dimensions) + (float2(CamPos.x + (Time * 40),CamPos.y) / 0.8);
    float2 worldPosB = (uv * Dimensions) + (float2(CamPos.x + (Time * 60),CamPos.y) / 1.4);
    float2 worldPosC = (uv * Dimensions) + (float2(CamPos.x + (Time * 100),CamPos.y) / 2);
    float3 color = SAMPLE_TEXTURE(text, uv);

    color.r *= 1.2;
    color.b /= 1.1;

    color /= 1.12;

    float brightness = (color.r + color.g + color.b) / 3;
    color = lerp(color,float3(brightness,brightness,brightness),0.3);

    color += fbm(worldPosA / 50) / 20 * uv.y;
    color.r += fbm(worldPosB / 50) / 16 * uv.y;

    color = lerp(color * brightness,color,0.15);

    float3 sampled = color;
    float2 samplepos = uv;
    float dist = 1;
    float strength = 0.95;
    float2 centerpos = float2(0.0 - abs(uv - 0.5) + 0.5);

    for (int i = 0; i < 24; i++){
        samplepos = ((uv - 0.5) / dist) + 0.5;
        sampled = SAMPLE_TEXTURE(text, samplepos).rgb;
        if (sampled.r + sampled.g + sampled.b > 1.6){
            color += 0.021 * strength;
        }
        strength /= 1.12;
        dist += 0.02;
    }

    if (rand(float2(worldPos.x,worldPos.x)) > 0.93){
        dist = 1;
        strength = 1 * (sin(Time + (worldPos.x * 2000)) / 2 + 0.5);
        sampled = color;
        float sample_brightness = 0;

        for (int i = 0; i < 32; i++){
            sampled = SAMPLE_TEXTURE(text, float2(uv.x,uv.y + ((uv.y / Dimensions.y) * dist))).rgb;
            sample_brightness = (sampled.r + sampled.g + sampled.b) / 3;
            if (sample_brightness > 0.86){
                color = lerp(color,float3(1.0,1.0,1.0),strength * 0.02);        
            }
            sampled = SAMPLE_TEXTURE(text, float2(uv.x,uv.y - ((uv.y / Dimensions.y) * dist))).rgb;
            sample_brightness = (sampled.r + sampled.g + sampled.b) / 3;
            if (sample_brightness > 0.86){
                color = lerp(color,float3(1.0,1.0,1.0),strength * 0.02);        
            }
            dist += 1;
            strength /= 1.1;
        }
    }

    color.b += (fbm(worldPosC / 50) / 3) * uv.y;

    dist = 1;
    float dir = 0;
    for (int i = 0; i < 3; i++){
        for (int i = 0; i < 6; i++){
            samplepos = float2(uv.x + (sin(dir) * 0.004 * dist),uv.y + (cos(dir) * 0.01 * dist));
            sampled = SAMPLE_TEXTURE(text, samplepos).rgb;
            color += sampled / 200;
            dir += 360 / 6;
        }
        dist += 1;
    }

    color *= float3(1.0,0.95,0.9);
    color *= 1.2 - (uv.y * uv.y / 2);

    return float4(color,1.0);
}

void SpriteVertexShader(inout float4 color    : COLOR0,
                        inout float2 texCoord : TEXCOORD0,
                        inout float4 position : SV_Position)
{
    position = mul(position, ViewMatrix);
    position = mul(position, TransformMatrix);
}

technique Shader
{
    pass pass0
    {
        VertexShader = compile vs_3_0 SpriteVertexShader();
        PixelShader = compile ps_3_0 SpritePixelShader();
    }
}