#define DECLARE_TEXTURE(Name, index) \
    texture Name: register(t##index); \
    sampler Name##Sampler: register(s##index)

#define SAMPLE_TEXTURE(Name, texCoord) tex2D(Name##Sampler, texCoord)

#define mod(x, y) (x - y * floor(x / y))

uniform float Time; // level.TimeActive
uniform float2 CamPos; // level.Camera.Position
uniform float2 Dimensions; // new Vector2(320, 180)

uniform float4x4 TransformMatrix;
uniform float4x4 ViewMatrix;

DECLARE_TEXTURE(text, 0);



float4 permute(float4 x){  return mod(((x*34.0)+1.0)*x, 289.0); }
float taylorInvSqrt(float r){return 1.79284291400159 - 0.85373472095314 * r;}


float gnoise(float3 v){ 
  	const float2  C = float2(1.0/6.0, 1.0/3.0) ;
  	const float4  D = float4(0.0, 0.5, 1.0, 2.0);

	// First corner
  	float3 i  = floor(v + dot(v, C.yyy) );
  	float3 x0 =   v - i + dot(i, C.xxx) ;

	// Other corners
  	float3 g = step(x0.yzx, x0.xyz);
  	float3 l = 1.0 - g;
  	float3 i1 = min( g.xyz, l.zxy );
  	float3 i2 = max( g.xyz, l.zxy );

  	//  x0 = x0 - 0. + 0.0 * C 
  	float3 x1 = x0 - i1 + 1.0 * C.xxx;
  	float3 x2 = x0 - i2 + 2.0 * C.xxx;
  	float3 x3 = x0 - 1. + 3.0 * C.xxx;

	// Permutations
  	i = mod(i, 289.0 ); 
  	float4 p = permute( permute( permute( 
             i.z + float4(0.0, i1.z, i2.z, 1.0 ))
           + i.y + float4(0.0, i1.y, i2.y, 1.0 )) 
           + i.x + float4(0.0, i1.x, i2.x, 1.0 ));

	// Gradients
	// ( N*N points uniformly over a square, mapped onto an octahedron.)
  	float n_ = 1.0/7.0; // N=7
  	float3  ns = n_ * D.wyz - D.xzx;
	
  	float4 j = p - 49.0 * floor(p * ns.z *ns.z);  //  mod(p,N*N)
	
  	float4 x_ = floor(j * ns.z);
  	float4 y_ = floor(j - 7.0 * x_ );    // mod(j,N)
	
  	float4 x = x_ *ns.x + ns.yyyy;
  	float4 y = y_ *ns.x + ns.yyyy;
  	float4 h = 1.0 - abs(x) - abs(y);
	
  	float4 b0 = float4( x.xy, y.xy );
  	float4 b1 = float4( x.zw, y.zw );
	
  	float4 s0 = floor(b0)*2.0 + 1.0;
  	float4 s1 = floor(b1)*2.0 + 1.0;
  	float4 sh = -step(h, float4(0,0,0,0));
	
  	float4 a0 = b0.xzyw + s0.xzyw*sh.xxyy ;
  	float4 a1 = b1.xzyw + s1.xzyw*sh.zzww ;
	
  	float3 p0 = float3(a0.xy,h.x);
  	float3 p1 = float3(a0.zw,h.y);
  	float3 p2 = float3(a1.xy,h.z);
  	float3 p3 = float3(a1.zw,h.w);

	//Normalise gradients
  	float4 norm = taylorInvSqrt(float4(dot(p0,p0), dot(p1,p1), dot(p2, p2), dot(p3,p3)));
  	p0 *= norm.x;
  	p1 *= norm.y;
  	p2 *= norm.z;
  	p3 *= norm.w;

	// lerp final noise value
  	float4 m = max(0.6 - float4(dot(x0,x0), dot(x1,x1), dot(x2,x2), dot(x3,x3)), 0.0);
  	m = m * m;
  	return 42.0 * dot( m*m, float4( dot(p0,x0), dot(p1,x1), 
                                dot(p2,x2), dot(p3,x3) ) );
}

float4 SpritePixelShader(float2 uv : TEXCOORD0) : COLOR0
{
    float2 worldPos = (uv * Dimensions) + CamPos;
    float2 screenpos = (uv * Dimensions);
    float4 color = 
    SAMPLE_TEXTURE(text, (screenpos + float2(0, gnoise(float3(worldPos / 20 + float2(Time * 1.2, Time - 1.7), Time)) * 6)) / Dimensions) / 12 + 
    SAMPLE_TEXTURE(text, (screenpos + float2(0, gnoise(float3(worldPos / 20 + float2(Time * 1.2, Time - 1.7), Time)) * 4)) / Dimensions) / 12 + 
    SAMPLE_TEXTURE(text, (screenpos + float2(0, gnoise(float3(worldPos / 20 + float2(Time * 1.2, Time - 1.7), Time)) * 2)) / Dimensions) / 12 + 
    SAMPLE_TEXTURE(text, (screenpos + float2(0, 0)) / Dimensions) / 3 + 
    SAMPLE_TEXTURE(text, (screenpos + float2(0, gnoise(float3(worldPos / 20 + float2(Time * 1.2, Time - 1.7), Time)) * -2)) / Dimensions) / 12 + 
    SAMPLE_TEXTURE(text, (screenpos + float2(0, gnoise(float3(worldPos / 20 + float2(Time * 1.2, Time - 1.7), Time)) * -4)) / Dimensions) / 12 + 
    SAMPLE_TEXTURE(text, (screenpos + float2(0, gnoise(float3(worldPos / 20 + float2(Time * 1.2, Time - 1.7), Time)) * -6)) / Dimensions) / 12;
    
    color *= 1.5;

    return color;
}

void SpriteVertexShader(inout float4 color    : COLOR0,
                        inout float2 texCoord : TEXCOORD0,
                        inout float4 position : SV_Position)
{
    position = mul(position, ViewMatrix);
    position = mul(position, TransformMatrix);
}

technique Shader
{
    pass pass0
    {
        VertexShader = compile vs_3_0 SpriteVertexShader();
        PixelShader = compile ps_3_0 SpritePixelShader();
    }
}