local drawableNinePatch = require("structs.drawable_nine_patch")
local drawableRectangle = require("structs.drawable_rectangle")
local drawableSprite = require("structs.drawable_sprite")

local syncedKevin = {}

local axesOptions = {
    Both = "both",
    Vertical = "vertical",
    Horizontal = "horizontal"
}

syncedKevin.name = "corkr900CoopHelper/SyncedKevin"
syncedKevin.depth = 0
syncedKevin.minimumSize = {24, 24}
syncedKevin.fieldInformation = {
    axes = {
        options = axesOptions,
        editable = false
    }
}
syncedKevin.placements = {}

for _, axis in pairs(axesOptions) do
    table.insert(syncedKevin.placements, {
        name = axis,
        data = {
            width = 24,
            height = 24,
            axes = axis,
            chillout = false
        }
    })
end

local frameTextures = {
    none = "objects/crushblock/block00",
    horizontal = "objects/crushblock/block01",
    vertical = "objects/crushblock/block02",
    both = "objects/crushblock/block03"
}

local ninePatchOptions = {
    mode = "border",
    borderMode = "repeat"
}

local kevinColor = {98 / 255, 34 / 255, 43 / 255}
local smallFaceTexture = "objects/crushblock/idle_face"
local giantFaceTexture = "objects/crushblock/giant_block00"

function syncedKevin.sprite(room, entity)
    local x, y = entity.x or 0, entity.y or 0
    local width, height = entity.width or 24, entity.height or 24

    local axes = entity.axes or "both"
    local chillout = entity.chillout

    local giant = height >= 48 and width >= 48 and chillout
    local faceTexture = giant and giantFaceTexture or smallFaceTexture

    local frameTexture = frameTextures[axes] or frameTextures["both"]
    local ninePatch = drawableNinePatch.fromTexture(frameTexture, ninePatchOptions, x, y, width, height)

    local rectangle = drawableRectangle.fromRectangle("fill", x + 2, y + 2, width - 4, height - 4, kevinColor)
    local faceSprite = drawableSprite.fromTexture(faceTexture, entity)

    faceSprite:addPosition(math.floor(width / 2), math.floor(height / 2))

    local sprites = ninePatch:getDrawableSprite()

    table.insert(sprites, 1, rectangle:getDrawableSprite())
    table.insert(sprites, 2, faceSprite)

    return sprites
end

function syncedKevin.rotate(room, entity, direction)
    local shouldRotate = math.abs(direction) % 2 == 1

    if shouldRotate then
        local axes = (entity.axes or ""):lower()

        if axes == "horizontal" then
            entity.axes = "vertical"

        elseif axes == "vertical" then
            entity.axes = "horizontal"
        end
    end

    return shouldRotate
end

return syncedKevin