local vector2 = require("#microsoft.xna.framework.vector2")
local monocle = require("#monocle")
local celeste = require("#celeste")
local lua_helper = celeste.Mod.LuaCutscenes.LuaHelper

function dash(xVector,yVector)
 player.OverrideDashDirection = vector2(xVector, yVector)
 helpers.setPlayerState(2)
 player:StartDash()
 wait(0.25)
 helpers.setPlayerState(11)
 player.OverrideDashDirection = nil
end

local function makeCoroutine(func)
  return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end

local coroutineEntity = monocle.Entity()

function onBegin()
  disableMovement()
  player.ForceCameraUpdate = true
  wait(0.5)
  walkTo(-13058)
  dash(0.8,0.8)
  walk(90,false,1.5)
  dash(-0.8,0.8)
  walk(-26,false,1.5,true)
  coroutineEntity:add(jump(1))
  walk(-80,false,1.6)
  dash(-1,0)
  walk(-48,false,1.6,true)
  coroutineEntity:add(jump(1))
  walk(-68,false,1.6,true)
  dash(-0.8,0.8)
  walk(-20,false,1.6,true)
  wait(0.5)
  walk(-20,false,1.6,true)
  wait(1.6)
  walk(25,false,1.5,true)
  coroutineEntity:add(jump(1))
  walk(60,false,1.5)
  dash(1,0)
  wait(2)
  walk(-30,false,1.5)
  coroutineEntity:add(jump(1))
  walk(-40,false,1.5)
  dash(-1,0)
  wait(0.8)
  walk(16,false,0.2)
  wait(0.2)
  player.DummyAutoAnimate = false
  player.Sprite:Play("SitDown")
  wait(5)
  completeArea(true)
end

function onEnd(room, wasSkipped)
  --completeArea(true)
end