local utils = require("utils")

local helpers = {}

helpers.modVersion = "1.0.0"

local modVersionKey = "_modVersion"
local pluginVersionKey = "_pluginVersion"

--- @param pluginVersion string
--- @param handler EntityHandler
function helpers.withVersion(pluginVersion, handler)
    -- Dynamic placements
    if utils.isCallable(handler.placements) then
        local orig = handler.placements --[[ @as fun():(PlacementInfo|PlacementInfo[]) ]]

        --- @diagnostic disable-next-line: assign-type-mismatch
        handler.placements = function ()
            local placements = orig()

            -- Multiple placements
            if utils.typeof(placements) == "table" and #placements > 0 then
                for _, placement in ipairs(placements) do
                    placement.data[modVersionKey] = helpers.modVersion
                    placement.data[pluginVersionKey] = pluginVersion
                end
            -- Single plaement
            else
                placements.data[modVersionKey] = helpers.modVersion
                placements.data[pluginVersionKey] = pluginVersion
            end

            return placements
        end
    -- Multiple placements
    elseif utils.typeof(handler.placements) == "table" and #handler.placements > 0 then
        for i, placement in ipairs(handler.placements) do
            placement.data[modVersionKey] = helpers.modVersion
            placement.data[pluginVersionKey] = pluginVersion
        end
    -- Single plaement
    else
        handler.placements.data[modVersionKey] = helpers.modVersion
        handler.placements.data[pluginVersionKey] = pluginVersion
    end

    if handler.ignoredFields then
        -- Dynamic ignored fields
        if utils.isCallable(handler.ignoredFields) then
            local orig = handler.ignoredFields --[[ @as fun(entity: Entity):string[] ]]

            --- @diagnostic disable-next-line: assign-type-mismatch
            handler.ignoredFields = function (entity)
                local ignored = orig(entity)

                table.insert(ignored, modVersionKey)
                table.insert(ignored, pluginVersionKey)

                return ignored
            end
        -- Static ignored fields
        else
            table.insert(handler.ignoredFields, modVersionKey)
            table.insert(handler.ignoredFields, pluginVersionKey)
        end
    else
        handler.ignoredFields = {"_name", "_id", "originX", "originY", modVersionKey, pluginVersionKey}
    end

    return handler
end

return helpers
