-- ignore this, just getting VScode to shut up
---@diagnostic disable: undefined-global
---@diagnostic disable: lowercase-global

-- The IDs of the choicers we've gone through are stored here. Choosing a back option moves back one step, and if the stack is empty, it'll end the choicer.
choicer_stack = {}

-- Every choicer used in this cutscene. They MUST all be in this table, or else there may be issues with moving between them.
choicers = {
    choicer_intro = {
        {
            dialog = "SenselessSpirit_SenselessZescent_CH1_MAIN_MUSEUMLORE_MAIN_YES",
            page = "choicer_MAIN",
            say = false
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CH1_MAIN_MUSEUMLORE_MAIN_NO",
            say = false,
            exit = true
        }
    },

    choicer_MAIN = {
        {
            dialog = "SenselessSpirit_SenselessZescent_CH1_MAIN_MUSEUMLORE_SILVER_FAQ"
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CHM_MAIN_MUSEUMLORE_YESREAD",
            page = "choicer_CHM_MAIN_PAGES",
            say = false
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CH1_MAIN_MUSEUMLORE_YESREAD",
            page = "choicer_CH1_MENU",
            say = false
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CH1_MAIN_MUSEUMLORE_SILVER_NOREAD",
            exit = true
        }
    },

    choicer_CH1_MENU = {
        {
            dialog = "SenselessSpirit_SenselessZescent_CH1_MAIN_MUSEUMLORE_SILVER_NONE",
            condition = function ()
                return not getFlag("CH1_MAIN_HAS_A_SILVER")
            end,
            say = false
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CH1_MAIN_MUSEUMLORE_SILVER_SELECT",
            condition = function ()
                return getFlag("CH1_MAIN_HAS_A_SILVER")
            end,
            page = "choicer_CH1_MAIN_SILVERS",
            say = false
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CH1_MAIN_MUSEUMTELEPORT_INTERLUDE_RAINBOW",
            condition = function ()
                return getFlag("CH1_INTERLUDE_RAINBOW")
            end,
            func = function ()
                return teleportTo(160,120,"rainbow_interlude_a","Respawn")
            end,
            say = false,
            exit = true
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CH1_MAIN_MUSEUMLORE_INTERLUDE_RAINBOW",
            condition = function ()
                return getFlag("CH1_INTERLUDE_RAINBOW_CLEAR")
            end,
            say = false,
            func = function ()
                setFlag("MUSEUM_INTERLUDEI_RAINBOW_COMICS_1")
                setFlag("CutsceneWait")
                while getFlag("CutsceneWait") do
                    wait(0.1)
                end
            end
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CH1_MAIN_MUSEUMLORE_LINGER_SELECT",
            say = true,
            condition = function ()
                return getFlag("SILVER_LONELINESS") or getFlag("SILVER_IGNORANCE") or getFlag("SILVER_NEGLECT") or getFlag("SILVER_GRIEF") or getFlag("SILVER_EXHAUSTION") or getFlag("SILVER_REGRET")
            end
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CH1_MAIN_MUSEUMLORE_VOIDACHIEVEMENT",
            say = true,
            condition = function ()
                return getFlag("CH1_MAIN_Void_FruitOfYourEfforts")
            end
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CH1_MAIN_MUSEUMLORE_SILVER_STOP",
            say = false,
            back = true
        }
    },

    choicer_CHM_MAIN_PAGES = {
        {
            dialog = "SenselessSpirit_SenselessZescent_CHM_MAIN_MUSEUMLORE_CELESTIALNOTE1",
            say = false,
            condition = function ()
                return getFlag("Museum_a-07")
            end,
            func = function ()
                setFlag("a-07Lever")
                setFlag("CutsceneWait")
                while getFlag("CutsceneWait") do
                    wait(0.1)
                end
                if getFlag("UNLOCKED_MADELINE") and not getFlag("NotMadeline") then
                    say("SenselessSpirit_SenselessZescent_CHM_MAIN_MUSEUMLORE_CelestialNote1_CommentGeneric")
                end
            end
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CH1_MAIN_MUSEUMLORE_SILVER_STOP",
            say = false,
            back = true
        }
    },

    choicer_CH1_MAIN_SILVERS = {
        {
            dialog = "SenselessSpirit_SenselessZescent_CH1_MAIN_MUSEUMLORE_SILVER01",
            condition = function ()
                return getFlag("CH1_MAIN_RECURRENCE_CLEAR")
            end
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CH1_MAIN_MUSEUMLORE_SILVER02",
            condition = function ()
                return getFlag("CH1_MAIN_PLURAL_CLEAR")
            end
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CH1_MAIN_MUSEUMLORE_SILVER03",
            condition = function ()
                return getFlag("CH1_MAIN_TRANQUIL_CLEAR")
            end
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CH1_MAIN_MUSEUMLORE_SILVER04",
            condition = function ()
                return getFlag("CH1_MAIN_RIVERS_CLEAR")
            end
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CH1_MAIN_MUSEUMLORE_SILVER05",
            condition = function ()
                return getFlag("CH1_MAIN_PRESSURE_CLEAR")
            end
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CH1_MAIN_MUSEUMLORE_SILVER06",
            condition = function ()
                return getFlag("CH1_MAIN_STRESS_CLEAR")
            end
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CH1_MAIN_MUSEUMLORE_SILVER07",
            condition = function ()
                return getFlag("CH1_MAIN_SHRINE_CLEAR")
            end
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CH1_MAIN_MUSEUMLORE_SILVER08",
            condition = function ()
                return getFlag("CH1_MAIN_TOWERS_CLEAR")
            end
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CH1_MAIN_MUSEUMLORE_SILVER09",
            condition = function ()
                return getFlag("CH1_MAIN_HALLS_CLEAR")
            end
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CH1_MAIN_MUSEUMLORE_SILVER10",
            condition = function ()
                return getFlag("CH1_MAIN_CORRIDORS_CLEAR")
            end
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CH1_MAIN_MUSEUMLORE_SILVER11",
            condition = function ()
                return getFlag("CH1_MAIN_CONFRONTATION_CLEAR")
            end
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CH1_MAIN_MUSEUMLORE_SILVER12",
            condition = function ()
                return getFlag("CH1_MAIN_ENERVATION_CLEAR")
            end
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CH1_MAIN_MUSEUMLORE_SILVER13",
            condition = function ()
                return getFlag("CH1_MAIN_INTERSONDER_CLEAR")
            end
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CH1_MAIN_MUSEUMLORE_SILVER14",
            condition = function ()
                return getFlag("CH1_MAIN_REPRISE_CLEAR")
            end
        },
        {
            dialog = "SenselessSpirit_SenselessZescent_CH1_MAIN_MUSEUMLORE_SILVER_STOP",
            say = false,
            back = true
        }
    }
}


function onTalk()
    disableMovement()
    setFlag("CinematicFadeFlag",true)
    say("SenselessSpirit_SenselessZescent_CH1_MAIN_MUSEUMLORE_SILVER_INTRO")

    -- First argument is the name of your choicer table.
    -- Second is if this choicer should be added to the choicer tree. Defaults to true.
    choiceDialog(convertChoicer("choicer_intro", false))
end

function onEnd(room, wasSkipped)
    setFlag("CinematicFadeFlag",false)
    enableMovement()
end

function convertChoicer(choicer, add_stack) -- Converts a choicer skeleton into a table usable by the choiceDialog helper function.
    add_stack = add_stack ~= false
    local newchoicer = {}
    for i, choice in ipairs(choicers[choicer]) do 
        local prev_stack = choice.prev_stack ~= false
        newchoicer[i] = {
            choice.dialog,
            repeatable = true,
            requires = choice.condition,
            onChosen = function()
                if choice.say ~= false then say(choice.dialog .. "_say") end
                if choice.func then choice.func() end
                if choice.page then
                    if choice.say == false then wait(0.2) end
                    choiceDialog(convertChoicer(choice.page, prev_stack))
                end
                if choice.exit then closeChoiceDialog() end
                if choice.back and not choice.exit then
                    if choice.say == false then wait(0.2) end
                    table.remove(choicer_stack, #choicer_stack) -- Remove the end of the stack
                    if #choicer_stack <= 0 then
                        closeChoiceDialog()
                    else
                        choiceDialog(convertChoicer(choicer_stack[#choicer_stack], false)) -- Create whatever table is at the end of the stack
                    end
                end
            end
        }
    end
    if add_stack then table.insert(choicer_stack, choicer) end
    return newchoicer
end
