local engine = require("#monocle.engine")
local monocle = require("#monocle")
local celeste = require("#celeste")

local pos=820

local function makeCoroutine(func)
  return monocle.Coroutine(lua_helper.LuaCoroutineToIEnumerator(coroutine.create(func)))
end

function onBegin()
  disableMovement()
  waitUntilOnGround()
  if (player.Position.X < pos) then
    walkTo(pos)
  else
    if (player.Position.X > (pos+16)) then
      walkTo(pos+16)
      walk(0.5)
    end
  end
  setFlag("intro_activate_crumble_blocks",true)
  wait(0.5)
  
  setFlag("intro_cutscene_debris_1",true)
  rumble(0.3)
  wait(0.1)
  walk(-8)
  wait(1)
  
  setFlag("intro_cutscene_debris_2",true)
  rumble(0.3)
  wait(0.2)
  walk(16)
  wait(1)
  
  setFlag("intro_cutscene_debris_3",true)
  rumble(0.6)
  wait(0.2)
  walk(-8)
  wait(1)
  walk(8)
  wait(1.5)
  setFlag("intro_cutscene_destroy_block",true)
  
  -- setFlag("intro_teleport",true)
  -- wait(2)
  -- teleportTo(824,520,"a01")
  -- setDarkness(0.1)
  -- setPlayerState("StReflectionFall")
  
  endCutscene()
end

function rumble(duration)
  sfx=playSound("event:/game/00_prologue/bridge_rumble_loop")
  shake(down,5000*duration)
  wait(duration)
  celeste.Audio.stop(sfx)
end
  
function onEnd(room, wasSkipped)
  if wasSkipped then
    teleportTo(1000,920,"a01")
    setFlag("a01_end_cutscene",true)
    playMusic("event:/music/Elekitu/MysticCave")
    setColorGrade("Elekitu/MulCaves/MulCave")
    setDarkness(0.1)
    enableMovement()
  end
end