local drawing = require("utils.drawing")
local utils = require("utils")

local genstar = {}
genstar.name = "EvaHelper/StarGenerator"
genstar.depth = 0
genstar.placements = {
	{
		name = "Star Generator",
		data = {
			starType = "Default",
			period = 0.17,
			starGenWidth = 128,
			starGenHeight = 128,
			starLengthMin = 12,
			starLengthMax = 36,
			ttlMin = 0.3,
			ttlMax = 0.5,
			rotateSpeedMin = 0.7,
			rotateSpeedMax = 1.0,
			active = true
		}
	}
}

genstar.fieldInformation = {
	starType = {
		options = { "Default" }
	},
	starGenWidth = { fieldType = "integer", minimumValue = 1 },
	starGenHeight = { fieldType = "integer", minimumValue = 1 },
	starLengthMin = { fieldType = "integer", minimumValue = 1 },
	starLengthMax = { fieldType = "integer", minimumValue = 1 },
}

genstar.fieldOrder = { "x", "y", "starGenWidth", "starGenHeight", "starType", "period", "starLengthMin", "starLengthMax", "ttlMin", "ttlMax", "rotateSpeedMin", "rotateSpeedMax", "active" }

function genstar.texture(room, entity)
	return 'Evidence02/objects_dance/ahorn/genstar'
end

function genstar.selection(room, entity)
	return utils.rectangle((entity.x or 0) - 8, (entity.y or 0) - 8, 16, 16)
end

function genstar.drawSelected(room, layer, entity, color)
	local x, y = entity.x or 0, entity.y or 0
	local r, g, b, a = love.graphics.getColor()
	
	love.graphics.setColor(1.0, 1.0, 1.0, 0.12)
	love.graphics.rectangle("fill", x + 0.5, y + 0.5, (entity.starGenWidth or 128) - 1, (entity.starGenHeight or 128) - 1)
	love.graphics.setColor(1.0, 1.0, 1.0, 1.0)
	love.graphics.rectangle("line", x + 0.5, y + 0.5, (entity.starGenWidth or 128) - 1, (entity.starGenHeight or 128) - 1)
	
	
	-- additional text
	local font = love.graphics.getFont()
	local textBatch = love.graphics.newText(font)
	drawing.callKeepOriginalColor(function()
		love.graphics.setColor(1.0, 1.0, 1.0, 1.0)
		drawing.printCenteredText('Star generator ', x + 8, y + 10, 180, 12, font, 1)
		drawing.printCenteredText(entity.starType ..', period'.. string.format("%.2f", entity.period) ..', rotate '.. string.format("%.2f", entity.rotateSpeedMin) ..'-'.. string.format("%.2f", entity.rotateSpeedMax), x + 8, y + 22, 180, 12, font, 1)
		drawing.printCenteredText('size ' .. string.format("%.2f", entity.starLengthMin) ..'-'.. string.format("%.2f", entity.starLengthMax) .. ', ttl ' .. string.format("%.2f", entity.ttlMin) ..'-'.. string.format("%.2f", entity.ttlMax), x + 8, y + 34, 180, 12, font, 1)
	end)
	love.graphics.draw(textBatch)
	
	-- reset color
	love.graphics.setColor(r, g, b, a)
end

return genstar
