local jautils = require("mods").requireFromPlugin("libraries.jautils")
local utils = require("utils")

local burret = {}
burret.name = "EvaHelper/BadelineTurret"
burret.depth = 0
burret.placements = {
    {
        name = "Badeline Turret",
        data = {
			bulletType = "Red",
			bulletSpeed = 240,
			cooldown = 2.0,
			startDelay = 0,
			direction = "AimPlayer",
			activateFlag = "",
			activateType = "Default",
			activateDistance = 0,
			
			activeFromStart = true,
			collideWalls = true,
			collideSpinners = false,
			sound = true
        }
    }
}

burret.fieldOrder = { "x", "y", "bulletType", "bulletSpeed", "cooldown", "startDelay", "direction", "activateType", "activateFlag", "activateDistance", "activeFromStart", "collideWalls", "collideSpinners", "sound" }

burret.fieldInformation = {
    bulletType = {
        options = { "Red", "Violet", "Blue", "Yellow", "Green", "White", "ArrowRed", "ArrowViolet", "ArrowBlue", "ArrowGreen", "ArrowYellow", "ArrowWhite", "StarRed", "StarOrange", "StarYellow", "StarGreen", "StarLightBlue", "StarBlue", "StarViolet", "StarWhite", "StarSmallRed", "StarSmallOrange", "StarSmallYellow", "StarSmallGreen", "StarSmallLightBlue", "StarSmallBlue", "StarSmallViolet", "StarSmallWhite", "StarBigBlue", "StarBigOrange", "StarBigGreen", "HeartRed", "HeartOrange", "HeartYellow", "HeartGreen", "HeartLightBlue", "HeartBlue", "HeartViolet", "HeartWhite", "PointerRed", "PointerGreen", "PointerBlue", "PointerViolet" }
    },
    direction = {
        options = { "Left", "Right", "Up", "Down", "AimPlayer" }
    },
    activateType = {
        options = { "Default", "Flag", "Player distance" }
    }
}

function burret.selection(room, entity)
    return utils.rectangle((entity.x or 0) - 8, (entity.y or 0) - 8, 16, 16)
end

function burret.texture(room, entity)
    return "/Evidence02/objects_eva/ahorn/badeline_turret"
end


return burret
