local viewportHandler = require("viewport_handler")
local drawableSpriteStruct = require("structs.drawable_sprite")

local blinkingDecal = {}
blinkingDecal.name = "EvaHelper/BlinkingDecal"
blinkingDecal.placements = {
    {
        name = "Blinking Decal",
        data = {
			texture = "decals/10-farewell/glitch_e00",
			duration = 0.8,
			flagEnable = "",
			depth = 0,
			enabled = true
        }
    }
}

blinkingDecal.fieldOrder = { "x", "y", "texture", "duration", "flagEnable", "depth", "enabled" }

function blinkingDecal.texture(room, entity)
    return entity.texture
end

function blinkingDecal.selection(room, entity)
    -- Same size, just need selection
    local sprite = drawableSpriteStruct.fromTexture(entity.texture, entity)
    return sprite:getRectangle()
end

return blinkingDecal
