local drawableSprite = require("structs.drawable_sprite")
local drawing = require("utils.drawing")
local utils = require("utils")

local gridEntity = {}
gridEntity.name = "EvaHelper/GameOfLife"
gridEntity.depth = 0
gridEntity.placements = {
	{
		name = "Game of Life",
		data = {
			sizeW = 48,
			sizeH = 32,
			cell = 5,
			period = 0.06,
			colorCell = "22FB22",
			colorBackground = "000000",
			opacityCell = 1,
			opacityBackground = 0.9,
			style = "Horizontal",
			inputDialog = "",
			damagePlayer = false,
			signalsGet = ""
		}
	}
}

gridEntity.fieldInformation = {
	style = {
		options = { "Horizontal", "Vertical", "None" }
	},
	colorCell = { fieldType = "color" },
	colorBackground = { fieldType = "color" },
	sizeW = { fieldType = "integer", minimumValue = 1 },
	sizeH = { fieldType = "integer", minimumValue = 1 },
	cell = { fieldType = "integer", minimumValue = 1 },
}

gridEntity.fieldOrder = { "x", "y", "sizeW", "sizeH", "cell", "period", "colorCell", "colorBackground", "opacityCell", "opacityBackground", "style", "inputDialog" }



function gridEntity.selection(room, entity)
	local x, y = entity.x or 0, entity.y or 0
	return utils.rectangle(x - 8, y - 8, 16, 16)
end

function gridEntity.draw(room, entity)
	local x, y = entity.x or 0, entity.y or 0
	local sizeW, sizeH = entity.sizeW or 48, entity.sizeH or 32
	local cz = entity.cell or 5
	
	
	local r, g, b, a = love.graphics.getColor()
	
	love.graphics.setColor(1.0, 0.0, 0.0, 0.2)
	for i = 0, sizeW do
		love.graphics.line(x + i * cz, y, x + i * cz, y + cz * sizeH)
	end
	for i = 0, sizeH do
		love.graphics.line(x, y + i * cz, x + cz * sizeW, y + i * cz)
	end
	
	-- reset color
	love.graphics.setColor(r, g, b, a)
	
	
	-- sprite draw
	local entitySprite = drawableSprite.fromTexture("Evidence02/objects_eva/ahorn/game_of_life")
	entitySprite.x = x
	entitySprite.y = y
	entitySprite:draw()
end

return gridEntity
