local utils = require("utils")

local helpyBasket = {}
helpyBasket.name = "EvaHelper/HelpyBasket"
helpyBasket.depth = 0
helpyBasket.placements = {
	{
		name = "Helpy HelpyBasket",
		data = {
			colorBasket = "FFAA00",
			colorGrid = "FFFFFF",
			renderNodes = false,
			left = true,
			countLayers = 4,
			radius = 24,
			actionOnGoal = "setFlag",
			signalOrFlag = ""
		}
	}
}

helpyBasket.fieldInformation = {
	colorBasket = { fieldType = "color" },
	colorGrid = { fieldType = "color" },
	radius = { fieldType = "integer" },
	countLayers = { fieldType = "integer" },
	actionOnGoal = {
		options = { "openBatteryDoor", "setFlag", "sendSignal" }
	}
}

function helpyBasket.selection(room, entity)
	local rad = entity.radius or 24
	return utils.rectangle((entity.x or 0) - rad, entity.y or 0, 2 * rad, 2 * rad)
end

function helpyBasket.texture(room, entity)
	return "Evidence02/objects_eva/ahorn/basket"
end

return helpyBasket
