local drawableSprite = require("structs.drawable_sprite")
local drawing = require("utils.drawing")
local utils = require("utils")

local gridEntity = {}
gridEntity.name = "EvaHelper/LangtonAnt"
gridEntity.depth = 0
gridEntity.placements = {
	{
		name = "Langton Ant",
		data = {
			sizeW = 100,
			sizeH = 100,
			pix = 2,
			speed = 20,
			period = 0.06,
			color1 = "FFFFFF",
			color2 = "FF0000",
			color3 = "22FB22",
			color4 = "4169E1",
			color5 = "EE82EE",
			colorBackground = "000000",
			style = "None",
			path = "62",
			opacityBackground = 0.9,
			signalsGet = ""
		}
	}
}

gridEntity.fieldInformation = {
	style = {
		options = { "Horizontal", "Vertical", "None" }
	},
	color1 = { fieldType = "color" },
	color2 = { fieldType = "color" },
	color3 = { fieldType = "color" },
	color4 = { fieldType = "color" },
	color5 = { fieldType = "color" },
	colorBackground = { fieldType = "color" },
	sizeW = { fieldType = "integer", minimumValue = 1 },
	sizeH = { fieldType = "integer", minimumValue = 1 },
	pix = { fieldType = "integer", minimumValue = 1 },
	speed = { fieldType = "integer", minimumValue = 1 },
}


function gridEntity.selection(room, entity)
	local x, y = entity.x or 0, entity.y or 0
	return utils.rectangle(x - 8, y - 8, 16, 16)
end

function gridEntity.draw(room, entity)
	local x, y = entity.x or 0, entity.y or 0
	local sizeW, sizeH = entity.sizeW or 100, entity.sizeH or 100
	local cz = entity.pix or 2
	
	
	local r, g, b, a = love.graphics.getColor()
	
	love.graphics.setColor(1.0, 0.0, 0.0, 0.2)
	for i = 0, sizeW do
		love.graphics.line(x + i * cz, y, x + i * cz, y + cz * sizeH)
	end
	for i = 0, sizeH do
		love.graphics.line(x, y + i * cz, x + cz * sizeW, y + i * cz)
	end
	
	-- reset color
	love.graphics.setColor(r, g, b, a)
	
	
	-- sprite draw
	local entitySprite = drawableSprite.fromTexture("Evidence02/objects_eva/ahorn/game_of_life")
	entitySprite.x = x
	entitySprite.y = y
	entitySprite:draw()
end

return gridEntity
