local drawableSprite = require("structs.drawable_sprite")

local langtonDirectionBlock = {}
langtonDirectionBlock.name = "EvaHelper/LangtonDirectionBlock"
langtonDirectionBlock.depth = 0
langtonDirectionBlock.placements = {
	{
		name = "Langton Direction Block",
		data = {
			width = 16,
			height = 16,
			colorIndex = 0
		}
	}
}

langtonDirectionBlock.fieldInformation = {
	colorIndex = { fieldType = "integer", minimumValue = 0, maximumValue = 5 },
}

function langtonDirectionBlock.draw(room, entity)
	
	local r, g, b, a = love.graphics.getColor()
		
	love.graphics.setColor(0.0, 0.0, 0.0, 1.0)
	love.graphics.rectangle("fill", entity.x + 0.5, entity.y + 0.5, entity.width - 1, entity.height - 1)
	love.graphics.setColor(0.5, 0.5, 0.5, 1.0)
	love.graphics.rectangle("line", entity.x + 2.5, entity.y + 2.5, entity.width - 5, entity.height - 5)
	
	-- reset color
	love.graphics.setColor(r, g, b, a)
end

return langtonDirectionBlock
